@php
     $version = $basicInfo->theme_version;
@endphp
@extends("frontend.layouts.layout-v$version")

@section('pageHeading')
    {{ 'Off Plan Properties' }}
@endsection

@section('metaKeywords')
    @if (!empty($seoInfo))
        {{ $seoInfo->meta_keyword_properties }}
    @endif
@endsection

@section('metaDescription')
    @if (!empty($seoInfo))
        {{ $seoInfo->meta_description_properties }}
    @endif
@endsection
@section('style')
    <meta http-equiv="Cache-Control" content="no-store" />
@endsection
@section('content')
    <!-- Map Start-->
    {{-- <div class="map-area border-top header-next pt-30">
        <div class="container">
            <div class="lazy-container radius-md ratio border">
                <div id="main-map"></div>
            </div>
        </div>
    </div> --}}
    <!-- Map End-->

    <!-- Listing Start -->
    <div class="listing-grid pt-40 pb-70 header-next">
        <div class="container">
            <div class="row gx-xl-5">
                <div class="col-xl-12">
                    <div class="row properties">
                        @foreach ($offplan as $property)
                          <div class="col-xxl-3 col-lg-4 col-sm-6">
                              <div class="product-default radius-md mb-30 aos-init aos-animate" data-aos="fade-up" data-aos-delay="100">
                                  <figure class="product-img">
                                      <a href="{{route('offplanobject', $property['project_id'])}}" class="lazy-container ratio ratio-1-1">
                                        <img class="lazyload" src="{{ $property['Avatar'] }}"
                                            data-src="{{ $property['Avatar'] }}">
                                      </a>
                                  </figure>
                                  <div class="product-details">
                                      <div class="d-flex align-items-center justify-content-between mb-10">
                                          <div class="author  ">
                                              <a class="color-medium" href="#" target="_self">
                                                <img class="blur-up ls-is-cached lazyloaded"
                                                      data-src="{{ $property['Organisation']['organizationLogo'] }}"
                                                      src="{{ $property['Organisation']['organizationLogo'] }}">
                                                  <span>{{ __('By') }} {{ $property['Organisation']['organizationName'] }}</span>
                                              </a>
                                          </div>

                                          <span class="product-category text-sm"></span>

                                      </div>
                                      <h3 class="product-title">
                                          <a
                                              href="{{route('offplanobject', $property['project_id'])}}">{{ $property['LongName'] }}</a>
                                      </h3>

                                      <span class="product-location icon-start"> <i class="fal fa-map-marker-alt"></i>
                                          {{ $property['Location']['address'] }}
                                      </span>
                                      <div class="product-price">
                                          <span class="new-price">{{ __('Price:') }} Starting {{ symbolPrice($property['LayoutPriceMin']) }}</span>
                                      </div>
                                      <ul class="product-info p-0 list-unstyled d-flex align-items-center">
                                          <li class="icon-start" data-tooltip="tooltip" data-bs-placement="top" title="{{ __('Area') }}">
                                              <i class="fal fa-vector-square"></i>
                                              <span>{{ $property['Layouts'][0]['layoutAreaTotal'] ?? 0 }} {{ __('Sqft') }}</span>
                                          </li>
                                          @php
                                            $buildingTypeIcon = '';
                                            if($property['Type']['name'] == 'Apartment' || $property['Type']['name'] == 'Penthouse'){
                                              $buildingTypeIcon = 'far fa-building';
                                            }else{
                                              $buildingTypeIcon = 'fas fa-home';
                                            }
                                          @endphp
                                            <li class="icon-start" data-tooltip="tooltip" data-bs-placement="top" title="{{ 'Property Type' }}">
                                                <i class="{{ $buildingTypeIcon }}"></i>
                                                <span>{{$property['Type']['name'] }}</span>
                                            </li>
                                      </ul>
                                  </div>
                                  <span class="label">{{ $property['Layouts'][0]['OfferingType']['name'] ?? '' }}</span>
                              </div>
                          </div>
                        @endforeach
                        {{-- <div class="col-lg-12">
                            <h3 class="text-center mt-5">{{ __('NO PROPERTY FOUND') . '!' }}</h3>
                        </div>
                        <div class="row">
                            <div class="col-lg-12 pagination justify-content-center customPaginagte">
                                {{ $property_contents->links() }}
                            </div>
                        </div> --}}
                    </div>
                    <div class="row">
                        <div class="col-lg-12 pagination justify-content-center customPaginagte">
                            {{ $offplan->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Listing End -->
@endsection

@section('script')
    <script>
        'use strict';
    </script>
@endsection
