


<?php if ($__env->exists('backend.partials.rtl-style')) echo $__env->make('backend.partials.rtl-style', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->startSection('content'); ?>
    <div class="page-header">
        <h4 class="page-title"><?php echo e(__('Work Process Section')); ?></h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="<?php echo e(route('admin.dashboard')); ?>">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#"><?php echo e(__('Home Page')); ?></a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#"><?php echo e(__('Work Process Section')); ?></a>
            </li>
        </ul>
    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-8">
                            <div class="card-title"><?php echo e(__('Update Work Process Section')); ?></div>
                        </div>

                        <div class="col-lg-4">
                            <?php if ($__env->exists('backend.partials.languages')) echo $__env->make('backend.partials.languages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-12">
                            <form id="workForm"
                                action="<?php echo e(route('admin.home_page.update_work_process_section', ['language' => request()->input('language')])); ?>"
                                method="POST">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label for=""><?php echo e(__('Title')); ?></label>
                                            <input type="text" class="form-control" name="title"
                                                value="<?php echo e(empty($data->title) ? '' : $data->title); ?>"
                                                placeholder="Enter Title">
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label for=""><?php echo e(__('Subtitle')); ?></label>
                                            <input type="text" class="form-control" name="subtitle"
                                                value="<?php echo e(empty($data->subtitle) ? '' : $data->subtitle); ?>"
                                                placeholder="Enter Subtitle">
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="card-footer">
                    <div class="row">
                        <div class="col-12 text-center">
                            <button type="submit" form="workForm" class="btn btn-success">
                                <?php echo e(__('Update')); ?>

                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card-title"><?php echo e(__('Wrok Processes')); ?></div>
                        </div>

                        <div class="col-lg-3">
                            <?php if ($__env->exists('backend.partials.languages')) echo $__env->make('backend.partials.languages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>

                        <div class="col-lg-4 offset-lg-1 mt-2 mt-lg-0">
                            <a href="#" data-toggle="modal" data-target="#createModal"
                                class="btn btn-primary btn-sm float-lg-right float-left"><i class="fas fa-plus"></i>
                                <?php echo e(__('Add')); ?></a>

                            <button class="btn btn-danger btn-sm float-right mr-2 d-none bulk-delete"
                                data-href="<?php echo e(route('admin.home_page.bulk_delete_work_process')); ?>">
                                <i class="flaticon-interface-5"></i> <?php echo e(__('Delete')); ?>

                            </button>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col">
                            <?php if(count($processes) == 0): ?>
                                <h3 class="text-center mt-2"><?php echo e(__('NO WORK PROCESS FOUND') . '!'); ?></h3>
                            <?php else: ?>
                                <div class="table-responsive">
                                    <table class="table table-striped mt-3" id="basic-datatables">
                                        <thead>
                                            <tr>
                                                <th scope="col">
                                                    <input type="checkbox" class="bulk-check" data-val="all">
                                                </th>
                                                <th scope="col"><?php echo e(__('Icon')); ?></th>
                                                <th scope="col"><?php echo e(__('Title')); ?></th>
                                                <th scope="col"><?php echo e(__('Serial Number')); ?></th>
                                                <th scope="col"><?php echo e(__('Actions')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $processes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $process): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td>
                                                        <input type="checkbox" class="bulk-check"
                                                            data-val="<?php echo e($process->id); ?>">
                                                    </td>
                                                    <td><i class="<?php echo e($process->icon); ?>"></i></td>
                                                    <td>
                                                        <?php echo e(strlen($process->title) > 30 ? mb_substr($process->title, 0, 30, 'UTF-8') . '...' : $process->title); ?>

                                                    </td>
                                                    <td><?php echo e($process->serial_number); ?></td>
                                                    <td>
                                                        <div class="dropdown">
                                                            <button class="btn btn-secondary dropdown-toggle btn-sm"
                                                                type="button" id="dropdownMenuButton"
                                                                data-toggle="dropdown" aria-haspopup="true"
                                                                aria-expanded="false">
                                                                <?php echo e(__('Select')); ?>

                                                            </button>

                                                            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">

                                                                <a class="dropdown-item editBtn" href="#"
                                                                    data-toggle="modal" data-target="#editModal"
                                                                    data-id="<?php echo e($process->id); ?>"
                                                                    data-icon="<?php echo e($process->icon); ?>"
                                                                    data-title="<?php echo e($process->title); ?>"
                                                                    data-serial_number="<?php echo e($process->serial_number); ?>"
                                                                    data-text="<?php echo e($process->text); ?>">
                                                                    <span class="btn-label">
                                                                        <i class="fas fa-edit"></i>
                                                                        <?php echo e(__('Edit')); ?>

                                                                    </span>
                                                                </a>

                                                                <form class="deleteForm d-block p-0 dropdown-item"
                                                                    action="<?php echo e(route('admin.home_page.delete_work_process', ['id' => $process->id])); ?>"
                                                                    method="post">
                                                                    <?php echo csrf_field(); ?>
                                                                    <button type="submit" class=" deleteBtn">
                                                                        <span class="btn-label">
                                                                            <i class="fas fa-trash"></i>
                                                                            <?php echo e(__('Delete')); ?>

                                                                        </span>
                                                                    </button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="card-footer"></div>
            </div>
        </div>
    </div>


    
    <?php echo $__env->make('backend.home-page.work-process-section.create', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    
    <?php echo $__env->make('backend.home-page.work-process-section.edit', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\creabiz\paradox\resources\views/backend/home-page/work-process-section/index.blade.php ENDPATH**/ ?>