

<?php $__env->startSection('content'); ?>
    <div class="page-header">
        <h4 class="page-title"><?php echo e(__('Edit Project')); ?></h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="<?php echo e(route('admin.dashboard')); ?>">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#"><?php echo e(__('Project Management')); ?></a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#"><?php echo e(__('Edit Project')); ?></a>
            </li>
        </ul>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="card-title d-inline-block"><?php echo e(__('Edit Project')); ?></div>
                    <a class="btn btn-info btn-sm float-right d-inline-block"
                        href="<?php echo e(route('admin.project_management.projects', ['language' => $defaultLang->code])); ?>">
                        <span class="btn-label">
                            <i class="fas fa-backward"></i>
                        </span>
                        <?php echo e(__('Back')); ?>

                    </a>
                    <?php
                        $dContent = App\Models\Project\ProjectContent::where('project_id', $project->id)
                            ->where('language_id', $defaultLang->id)
                            ->first();
                        $slug = !empty($dContent) ? $dContent->slug : '';
                    ?>
                    <?php if($dContent): ?>
                        <a class="btn btn-success btn-sm float-right mr-1 d-inline-block"
                            href="<?php echo e(route('frontend.projects.details', ['slug' => $slug, 'id' => $project->id])); ?>"
                            target="_blank">
                            <span class="btn-label">
                                <i class="fas fa-eye"></i>
                            </span>
                            <?php echo e(__('Preview')); ?>

                        </a>
                    <?php endif; ?>

                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-10 offset-lg-1">
                            <div class="alert alert-danger pb-1 dis-none" id="carErrors">
                                <button type="button" class="close" data-dismiss="alert">×</button>
                                <ul></ul>
                            </div>


                            <div class="row">
                                <div class="col-lg-6">
                                    <label for="" class="mb-2"><strong><?php echo e(__('Gallery Images')); ?>

                                            **</strong></label>
                                    <table class="table table-striped" id="imgtable">

                                        <?php $__currentLoopData = $gallery_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr class="trdb table-row" id="trdb<?php echo e($item->id); ?>">
                                                <td>
                                                    <div class="">
                                                        <img class="thumb-preview wf-150"
                                                            src="<?php echo e(asset('assets/img/project/gallery-images/' . $item->image)); ?>"
                                                            alt="Ad Image">
                                                    </div>
                                                </td>
                                                <td>
                                                    <i class="fa fa-times rmvbtndb" data-indb="<?php echo e($item->id); ?>"></i>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </table>

                                    <form action="<?php echo e(route('admin.project.gallery_image_store')); ?>" id="my-dropzone"
                                        enctype="multipart/formdata" class="dropzone create">
                                        <?php echo csrf_field(); ?>
                                        <div class="fallback">
                                            <input name="file" type="file" multiple />
                                        </div>
                                        <input type="hidden" value="<?php echo e($project->id); ?>" name="project_id">
                                    </form>
                                    <p class="em text-danger mb-0" id="errgallery_images"></p>

                                </div>

                                <div class="col-lg-6">
                                    <label for="" class="mb-2"><strong><?php echo e(__('Floor Plan Images')); ?>

                                            **</strong></label>
                                    <table class="table table-striped" id="imgtable">

                                        <?php $__currentLoopData = $floor_plan_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr class="trdb table-row" id="trdb<?php echo e($item->id); ?>">
                                                <td>
                                                    <div class="">
                                                        <img class="thumb-preview wf-150"
                                                            src="<?php echo e(asset('assets/img/project/floor-paln-images/' . $item->image)); ?>"
                                                            alt="Ad Image">
                                                    </div>
                                                </td>
                                                <td>
                                                    <i class="fa fa-times rmvbtndb2" data-indb="<?php echo e($item->id); ?>"></i>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </table>

                                    <form action="<?php echo e(route('admin.project.floor_plan_image_store')); ?>" id="my-dropzone2"
                                        enctype="multipart/formdata" class="dropzone create">
                                        <?php echo csrf_field(); ?>
                                        <div class="fallback">
                                            <input name="file" type="file" multiple />
                                        </div>
                                        <input type="hidden" value="<?php echo e($project->id); ?>" name="project_id">
                                    </form>
                                    <p class="em text-danger mb-0" id="errfloor_plan_images"></p>
                                </div>
                            </div>

                            <form id="carForm"
                                action="<?php echo e(route('admin.project_management.update_project', $project->id)); ?>"
                                method="POST" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="project_id" value="<?php echo e($project->id); ?>">
                                <input type="hidden" name="vendor_id" value="<?php echo e($project->vendor_id); ?>">

                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for=""><?php echo e(__('Featured Image') . '*'); ?></label>
                                            <br>
                                            <div class="thumb-preview">
                                                <img src="<?php echo e($project->featured_image ? asset('assets/img/project/featured/' . $project->featured_image) : asset('assets/admin/img/noimage.jpg')); ?>"
                                                    alt="..." class="uploaded-img">
                                            </div>
                                            <div class="mt-3">
                                                <div role="button" class="btn btn-primary btn-sm upload-btn">
                                                    <?php echo e(__('Choose Image')); ?>

                                                    <input type="file" class="img-input" name="featured_image">
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>

                                <div class="row">

                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label><?php echo e(__('Min Price') . ' (' . $settings->base_currency_text . ')'); ?>

                                                *</label>
                                            <input type="number" class="form-control" name="min_price"
                                                placeholder="Enter Minimum Price" value="<?php echo e($project->min_price); ?>">
                                        </div>
                                    </div>

                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label><?php echo e(__('Max Price') . ' (' . $settings->base_currency_text . ')'); ?>

                                            </label>
                                            <input type="number" class="form-control" name="max_price"
                                                placeholder="Enter Maximum Price" value="<?php echo e($project->max_price); ?>">
                                        </div>
                                    </div>

                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label><?php echo e(__('Featured')); ?> *</label>
                                            <select name="featured" id="" class="form-control">
                                                <option <?php echo e($project->featured == 0 ? 'selected' : ''); ?> value="0">
                                                    <?php echo e(__('No')); ?>

                                                </option>
                                                <option <?php echo e($project->featured == 1 ? 'selected' : ''); ?> value="1">
                                                    <?php echo e(__('Yes')); ?>

                                                </option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label><?php echo e(__('Status')); ?> *</label>
                                            <select name="status" id="" class="form-control">
                                                <option <?php echo e($project->status == 1 ? 'selected' : ''); ?> value="1">
                                                    <?php echo e(__('Complete')); ?></option>
                                                <option <?php echo e($project->status == 0 ? 'selected' : ''); ?> value="0">
                                                    <?php echo e(__('Under Construction')); ?></option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label><?php echo e(__('Latitude')); ?> </label>
                                            <input type="text" class="form-control" value="<?php echo e($project->latitude); ?>"
                                                name="latitude" placeholder="Enter Latitude">
                                        </div>
                                    </div>

                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label><?php echo e(__('Longitude')); ?> </label>
                                            <input type="text" class="form-control" value="<?php echo e($project->longitude); ?>"
                                                name="longitude" placeholder="Enter Longitude">
                                        </div>
                                    </div>

                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label for=""><?php echo e(__('Vendor')); ?></label>
                                            <select name="vendor_id" class="form-control vendor js-example-basic-single1">
                                                <option value="0" selected ><?php echo e(__('Please Select')); ?>

                                                </option>
                                                <?php $__currentLoopData = $vendors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option <?php echo e($project->vendor_id == $item->id ? 'selected' : ''); ?>

                                                        value="<?php echo e($item->id); ?>">
                                                        <?php echo e($item->username); ?> <?php echo e($item->id == 0 ? __('(admin)') : ''); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                    <?php
                                        $agents = App\Models\Agent::where('vendor_id', $project->vendor_id)
                                            ->select('id', 'username')
                                            ->where('status', 1)
                                            ->get();
                                    ?>
                                    <div class="col-lg-3">
                                        <div class="form-group agent <?php if(empty($project->agent_id)): ?> d-none <?php endif; ?>">
                                            <label for=""><?php echo e(__('Agent')); ?></label>
                                            <select name="agent_id" class="form-control agent_id js-example-basic-single1">
                                                <option value="0" selected><?php echo e(__('Please Select')); ?>

                                                </option>
                                                <?php $__currentLoopData = $agents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $agent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($agent->id); ?>"
                                                        <?php echo e($agent->id == $project->agent_id ? 'selected' : ''); ?>>
                                                        <?php echo e($agent->username); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <p class="text-warning">
                                                <?php echo e(__('if you do not select any agent, then this property will be listed under Vendor')); ?>

                                            </p>
                                        </div>
                                    </div>


                                </div>

                                <div id="accordion" class="mt-3">
                                    <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $projectContent = App\Models\Project\ProjectContent::where(
                                                'project_id',
                                                $project->id,
                                            )
                                                ->where('language_id', $language->id)
                                                ->first();

                                        ?>
                                        <div class="version">
                                            <div class="version-header" id="heading<?php echo e($language->id); ?>">
                                                <h5 class="mb-0">
                                                    <button type="button" class="btn btn-link" data-toggle="collapse"
                                                        data-target="#collapse<?php echo e($language->id); ?>"
                                                        aria-expanded="<?php echo e($language->is_default == 1 ? 'true' : 'false'); ?>"
                                                        aria-controls="collapse<?php echo e($language->id); ?>">
                                                        <?php echo e($language->name . __(' Language')); ?>

                                                        <?php echo e($language->is_default == 1 ? '(Default)' : ''); ?>

                                                    </button>
                                                </h5>
                                            </div>

                                            <div id="collapse<?php echo e($language->id); ?>"
                                                class="collapse <?php echo e($language->is_default == 1 ? 'show' : ''); ?>"
                                                aria-labelledby="heading<?php echo e($language->id); ?>" data-parent="#accordion">
                                                <div class="version-body">
                                                    <div class="row">
                                                        <div class="col-lg-8">
                                                            <div
                                                                class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                <label><?php echo e(__('Title*')); ?></label>
                                                                <input type="text" class="form-control"
                                                                    name="<?php echo e($language->code); ?>_title"
                                                                    placeholder="Enter Title"
                                                                    value="<?php echo e($projectContent ? $projectContent->title : ''); ?>">
                                                            </div>
                                                        </div>

                                                        <div class="col-lg-4">
                                                            <div
                                                                class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                <label><?php echo e(__('Address') . '*'); ?> </label>
                                                                <input type="text"
                                                                    name="<?php echo e($language->code); ?>_address"
                                                                    placeholder="Enter Address"
                                                                    value="<?php echo e(@$projectContent->address); ?>"
                                                                    class="form-control">
                                                            </div>
                                                        </div>


                                                    </div>
                                                    <div class="row">
                                                        <div class="col-lg-12">
                                                            <div
                                                                class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                <label><?php echo e(__('Description')); ?> *</label>
                                                                <textarea class="form-control summernote " id="<?php echo e($language->code); ?>_description"
                                                                    name="<?php echo e($language->code); ?>_description" data-height="300"><?php echo e(@$projectContent->description); ?></textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-lg-12">
                                                            <div
                                                                class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                <label><?php echo e(__('Meta Keywords')); ?> *</label>
                                                                <input class="form-control"
                                                                    name="<?php echo e($language->code); ?>_meta_keyword"
                                                                    placeholder="Enter Meta Keywords"
                                                                    data-role="tagsinput"
                                                                    value="<?php echo e($projectContent ? $projectContent->meta_keyword : ''); ?>">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-lg-12">
                                                            <div
                                                                class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                <label><?php echo e(__('Meta Description')); ?> *</label>
                                                                <textarea class="form-control" name="<?php echo e($language->code); ?>_meta_description" rows="5"
                                                                    placeholder="Enter Meta Description"><?php echo e($projectContent ? $projectContent->meta_description : ''); ?></textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col">
                                                            <?php $currLang = $language; ?>

                                                            <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php if($language->id == $currLang->id) continue; ?>

                                                                <div class="form-check py-0">
                                                                    <label class="form-check-label">
                                                                        <input class="form-check-input" type="checkbox"
                                                                            onchange="cloneInput('collapse<?php echo e($currLang->id); ?>', 'collapse<?php echo e($language->id); ?>', event)">
                                                                        <span
                                                                            class="form-check-sign"><?php echo e(__('Clone for')); ?>

                                                                            <strong
                                                                                class="text-capitalize text-secondary"><?php echo e($language->name); ?></strong>
                                                                            <?php echo e(__('language')); ?></span>
                                                                    </label>
                                                                </div>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>

                                <div class="row">
                                    <div class="col-lg-12" id="variation_pricing">
                                        <h4 for=""><?php echo e(__('Additional Features (Optional)')); ?></h4>
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th><?php echo e(__('Label')); ?></th>
                                                    <th><?php echo e(__('Value')); ?></th>
                                                    <th><a href="javascrit:void(0)"
                                                            class="btn  btn-sm btn-success addRow"><i
                                                                class="fas fa-plus-circle"></i></a></th>
                                                </tr>
                                            <tbody id="tbody">

                                                <?php if(count($specifications) > 0): ?>
                                                    <?php $__currentLoopData = $specifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $specification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr>
                                                            <td>
                                                                <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php
                                                                        $sp_content = App\Models\Project\SpacificationContent::where(
                                                                            [
                                                                                ['language_id', $language->id],
                                                                                [
                                                                                    'project_spacification_id',
                                                                                    $specification->id,
                                                                                ],
                                                                            ],
                                                                        )->first();
                                                                    ?>
                                                                    <div
                                                                        class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                        <input type="text"
                                                                            name="<?php echo e($language->code); ?>_label[]"
                                                                            value="<?php echo e(@$sp_content->label); ?>"
                                                                            class="form-control"
                                                                            placeholder="Label (<?php echo e($language->name); ?>)">
                                                                    </div>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </td>
                                                            <td>
                                                                <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php
                                                                        $sp_content = App\Models\Project\SpacificationContent::where(
                                                                            [
                                                                                ['language_id', $language->id],
                                                                                [
                                                                                    'project_spacification_id',
                                                                                    $specification->id,
                                                                                ],
                                                                            ],
                                                                        )->first();
                                                                    ?>
                                                                    <div
                                                                        class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                        <input type="text"
                                                                            name="<?php echo e($language->code); ?>_value[]"
                                                                            value="<?php echo e(@$sp_content->value); ?>"
                                                                            class="form-control"
                                                                            placeholder="Value (<?php echo e($language->name); ?>)">
                                                                    </div>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </td>
                                                            <td>
                                                                <a href="javascript:void(0)"
                                                                    data-specification="<?php echo e($specification->id); ?>"
                                                                    class="btn  btn-sm btn-danger deleteSpecification">
                                                                    <i class="fas fa-minus"></i></a>
                                                            </td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php else: ?>
                                                    <tr>
                                                        <td>
                                                            <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <div
                                                                    class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                    <input type="text"
                                                                        name="<?php echo e($language->code); ?>_label[]"
                                                                        class="form-control"
                                                                        placeholder="Label (<?php echo e($language->name); ?>)">
                                                                </div>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </td>
                                                        <td>
                                                            <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <div
                                                                    class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                    <input type="text"
                                                                        name="<?php echo e($language->code); ?>_value[]"
                                                                        class="form-control"
                                                                        placeholder="Value (<?php echo e($language->name); ?>)">
                                                                </div>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </td>
                                                        <td>
                                                            <a href="javascript:void(0)"
                                                                class="btn btn-danger  btn-sm deleteRow">
                                                                <i class="fas fa-minus"></i></a>
                                                        </td>
                                                    </tr>
                                                <?php endif; ?>
                                            </tbody>
                                            </thead>
                                        </table>
                                    </div>
                                </div>


                                <div id="galleries"></div>
                                <div id="floorPlan"></div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="card-footer">
                    <div class="row">
                        <div class="col-12 text-center">
                            <button type="submit" id="PropertySubmit" class="btn btn-primary">
                                <?php echo e(__('Update')); ?>

                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php
    $languages = App\Models\Language::get();
    $labels = '';
    $values = '';
    foreach ($languages as $language) {
        $label_name = $language->code . '_label[]';
        $value_name = $language->code . '_value[]';
        if ($language->direction == 1) {
            $direction = 'form-group rtl text-right';
        } else {
            $direction = 'form-group';
        }

        $labels .=
            "<div class='$direction'><input type='text' name='" .
            $label_name .
            "' class='form-control' placeholder='Label ($language->name)'></div>";
        $values .= "<div class='$direction'><input type='text' name='$value_name' class='form-control' placeholder='Value ($language->name)'></div>";
    }
?>

<?php $__env->startSection('script'); ?>
    <script>
        var labels = "<?php echo $labels; ?>";
        var values = "<?php echo $values; ?>";

        var galleryStoreUrl = "<?php echo e(route('admin.project.gallery_image_store', ['vendor_id' => $project->vendor_id])); ?>";
        var galleryRemoveUrl = "<?php echo e(route('admin.project.gallery_imagermv')); ?>";
        var floorPlanStoreUrl = "<?php echo e(route('admin.project.floor_plan_image_store')); ?>";
        var floorPlanRemoveUrl = "<?php echo e(route('admin.project.floor_plan_imagermv')); ?>";
        let agentUrl = "<?php echo e(route('admin.property_management.get_agent')); ?>";
        var galleryImagRrmvdbUrl = "<?php echo e(route('admin.project.gallery_imgdbrmv')); ?>";
        var floorPlanRmvdbUrl = "<?php echo e(route('admin.project.floor_plan_imgdbrmv')); ?>";
        var specificationRmvUrl = "<?php echo e(route('admin.project_management.specification_delete')); ?>";
        var galleryImages = <?php echo e($uploadGImg); ?>;
    </script>
    <script type="text/javascript" src="<?php echo e(asset('assets/js/admin-partial.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('assets/js/admin-project-dropzone.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/property.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\creabiz\paradox\resources\views/backend/project/edit.blade.php ENDPATH**/ ?>