<?php
     $version = $basicInfo->theme_version;
?>


<?php $__env->startSection('pageHeading'); ?>
    <?php echo e('Off Plan Properties'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('metaKeywords'); ?>
    <?php if(!empty($seoInfo)): ?>
        <?php echo e($seoInfo->meta_keyword_properties); ?>

    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('metaDescription'); ?>
    <?php if(!empty($seoInfo)): ?>
        <?php echo e($seoInfo->meta_description_properties); ?>

    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('style'); ?>
    <meta http-equiv="Cache-Control" content="no-store" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- Map Start-->
    
    <!-- Map End-->

    <!-- Listing Start -->
    <div class="listing-grid pt-40 pb-70 header-next">
        <div class="container">
            <div class="row gx-xl-5">
                <div class="col-xl-12">
                    <div class="row properties">
                        <?php $__currentLoopData = $offplan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <div class="col-xxl-3 col-lg-4 col-sm-6">
                              <div class="product-default radius-md mb-30 aos-init aos-animate" data-aos="fade-up" data-aos-delay="100">
                                  <figure class="product-img">
                                      <a href="<?php echo e(route('offplanobject', $property['project_id'])); ?>" class="lazy-container ratio ratio-1-1">
                                        <img class="lazyload" src="<?php echo e($property['Avatar']); ?>"
                                            data-src="<?php echo e($property['Avatar']); ?>">
                                      </a>
                                  </figure>
                                  <div class="product-details">
                                      <div class="d-flex align-items-center justify-content-between mb-10">
                                          <div class="author  ">
                                              <a class="color-medium" href="#" target="_self">
                                                <img class="blur-up ls-is-cached lazyloaded"
                                                      data-src="<?php echo e($property['Organisation']['organizationLogo']); ?>"
                                                      src="<?php echo e($property['Organisation']['organizationLogo']); ?>">
                                                  <span><?php echo e(__('By')); ?> <?php echo e($property['Organisation']['organizationName']); ?></span>
                                              </a>
                                          </div>

                                          <span class="product-category text-sm"></span>

                                      </div>
                                      <h3 class="product-title">
                                          <a
                                              href="<?php echo e(route('offplanobject', $property['project_id'])); ?>"><?php echo e($property['LongName']); ?></a>
                                      </h3>

                                      <span class="product-location icon-start"> <i class="fal fa-map-marker-alt"></i>
                                          <?php echo e($property['Location']['address']); ?>

                                      </span>
                                      <div class="product-price">
                                          <span class="new-price"><?php echo e(__('Price:')); ?> Starting <?php echo e(symbolPrice($property['LayoutPriceMin'])); ?></span>
                                      </div>
                                      <ul class="product-info p-0 list-unstyled d-flex align-items-center">
                                          <li class="icon-start" data-tooltip="tooltip" data-bs-placement="top" title="<?php echo e(__('Area')); ?>">
                                              <i class="fal fa-vector-square"></i>
                                              <span><?php echo e($property['Layouts'][0]['layoutAreaTotal'] ?? 0); ?> <?php echo e(__('Sqft')); ?></span>
                                          </li>
                                          <?php
                                            $buildingTypeIcon = '';
                                            if($property['Type']['name'] == 'Apartment' || $property['Type']['name'] == 'Penthouse'){
                                              $buildingTypeIcon = 'far fa-building';
                                            }else{
                                              $buildingTypeIcon = 'fas fa-home';
                                            }
                                          ?>
                                            <li class="icon-start" data-tooltip="tooltip" data-bs-placement="top" title="<?php echo e('Property Type'); ?>">
                                                <i class="<?php echo e($buildingTypeIcon); ?>"></i>
                                                <span><?php echo e($property['Type']['name']); ?></span>
                                            </li>
                                      </ul>
                                  </div>
                                  <span class="label"><?php echo e($property['Layouts'][0]['OfferingType']['name'] ?? ''); ?></span>
                              </div>
                          </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        
                    </div>
                    <div class="row">
                        <div class="col-lg-12 pagination justify-content-center customPaginagte">
                            <?php echo e($offplan->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Listing End -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        'use strict';
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("frontend.layouts.layout-v$version", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\creabiz\paradox\resources\views/frontend/property/offplanindex.blade.php ENDPATH**/ ?>