


<?php if ($__env->exists('backend.partials.rtl_style')) echo $__env->make('backend.partials.rtl_style', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->startSection('content'); ?>
    <div class="page-header">
        <h4 class="page-title"><?php echo e(__('Properties')); ?></h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="<?php echo e(route('admin.dashboard')); ?>">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#"><?php echo e(__('Property Management')); ?></a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#"><?php echo e(__('Properties')); ?></a>
            </li>
        </ul>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-3">
                            <div class="card-title d-inline-block"><?php echo e(__('Properties')); ?></div>
                        </div>

                        <div class="col-lg-3">
                            <form action="<?php echo e(route('admin.property_management.properties')); ?>" method="get"
                                id="carSearchForm">
                                <div class="row">
                                    <div class="col-lg-6">
                                        <select name="vendor_id" id="" class="select2"
                                            onchange="document.getElementById('carSearchForm').submit()">
                                            <option value="" selected><?php echo e(__('All')); ?></option>
                                            <option value="admin" <?php if(request()->input('vendor_id') == 'admin'): echo 'selected'; endif; ?>>
                                                <?php echo e(Auth::guard('admin')->user()->username); ?> <span
                                                    class="badge bg-success"><?php echo e('(' . __('Admin') . ')'); ?></span> </option>
                                            <?php $__currentLoopData = $vendors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vendor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option <?php if($vendor->id == request()->input('vendor_id')): echo 'selected'; endif; ?> value="<?php echo e($vendor->id); ?>">
                                                    <?php echo e($vendor->username); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="col-lg-6">
                                        <input type="text" name="title" value="<?php echo e(request()->input('title')); ?>"
                                            class="form-control" placeholder="Title">
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-lg-3">
                            <?php if ($__env->exists('backend.partials.languages')) echo $__env->make('backend.partials.languages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>

                        <div class="col-lg-3 mt-2 mt-lg-0">
                            <a href="<?php echo e(route('admin.property_management.type')); ?>"
                                class="btn btn-primary btn-sm float-right"><i class="fas fa-plus"></i>
                                <?php echo e(__('Add Property')); ?></a>

                            <button class="btn btn-danger btn-sm float-right mr-2 d-none bulk-delete"
                                data-href="<?php echo e(route('admin.property_management.bulk_delete_property')); ?>"><i
                                    class="flaticon-interface-5"></i>
                                <?php echo e(__('Delete')); ?></button>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-12">
                            <?php if(count($properties) == 0): ?>
                                <h3 class="text-center"><?php echo e(__('NO PROPERTY FOUND!')); ?></h3>
                            <?php else: ?>
                                <div class="table-responsive">
                                    <table class="table table-striped mt-3">
                                        <thead>
                                            <tr>
                                                <th scope="col">
                                                    <input type="checkbox" class="bulk-check" data-val="all">
                                                </th>
                                                <th scope="col"><?php echo e(__('Title')); ?></th>
                                                <th scope="col"><?php echo e(__('Post by')); ?></th>
                                                <th scope="col"><?php echo e(__('Type')); ?></th>
                                                <th scope="col"><?php echo e(__('City')); ?></th>
                                                <th scope="col"><?php echo e(__('Approval Status')); ?></th>
                                                <th scope="col"><?php echo e(__('Featured')); ?></th>
                                                <th scope="col"><?php echo e(__('Status')); ?></th>
                                                <th scope="col"><?php echo e(__('Actions')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td>
                                                        <input type="checkbox" class="bulk-check"
                                                            data-val="<?php echo e($property->id); ?>">
                                                    </td>
                                                    <td class="table-title">
                                                        <?php
                                                            $property_content = $property->getContent($language->id);
                                                            if (is_null($property_content)) {
                                                                $property_content = $property
                                                                    ->propertyContents()
                                                                    ->first();
                                                            }
                                                        ?>
                                                        <?php if(!empty($property_content)): ?>
                                                            <a href="<?php echo e(route('frontend.property.details', ['slug' => $property_content->slug])); ?>"
                                                                target="_blank">
                                                                <?php echo e(strlen(@$property_content->title) > 100 ? mb_substr(@$property_content->title, 0, 100, 'utf-8') . '...' : @$property_content->title); ?>

                                                            </a>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <?php if($property->vendor_id != 0): ?>
                                                            <a
                                                                href="<?php echo e(route('admin.vendor_management.vendor_details', ['id' => @$property->vendor->id, 'language' => $defaultLang->code])); ?>"><?php echo e(@$property->vendor->username); ?></a>
                                                        <?php else: ?>
                                                            <span class="badge badge-success"><?php echo e(__('Admin')); ?></span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <?php echo e($property->type); ?>

                                                    </td>
                                                    <td>
                                                        <?php echo e($property->cityContent?->name); ?>

                                                    </td>
                                                    <td>

                                                        <form class="d-inline-block"
                                                            action="<?php echo e(route('admin.property_management.approve_status')); ?>"
                                                            method="POST">
                                                            <?php echo csrf_field(); ?>
                                                            <input type="hidden" name="property"
                                                                value="<?php echo e($property->id); ?>">
                                                            <select
                                                                onchange="$('.request-loader').addClass('show'); this.form.submit();"
                                                                class="form-control  <?php if($property->approve_status == 1): ?> bg-success <?php elseif($property->approve_status == 0): ?>
                                                                bg-warning <?php else: ?> bg-danger <?php endif; ?> form-control-sm"
                                                                name="approve_status">
                                                                <option value="2"
                                                                    <?php echo e($property->approve_status == 2 ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Rejected')); ?>

                                                                </option>
                                                                <option value="1"
                                                                    <?php echo e($property->approve_status == 1 ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Approve')); ?>

                                                                </option>
                                                                <option value="0"
                                                                    <?php echo e($property->approve_status == 0 ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Pending')); ?>

                                                                </option>
                                                            </select>
                                                        </form>
                                                    </td>
                                                    <td>

                                                        <?php

                                                            $featuredProperty = $property
                                                                ->featuredProperties()
                                                                ->latest()
                                                                ->first();

                                                            $pendingfeatured = false;
                                                            $featuredExpired = false;
                                                            $featured = false;

                                                            if (
                                                                !empty($featuredProperty) &&
                                                                $featuredProperty->status == 0 &&
                                                                $featuredProperty->start_date == null &&
                                                                $featuredProperty->end_date == null
                                                            ) {
                                                                $pendingfeatured = true;
                                                            } elseif (
                                                                !empty($featuredProperty) &&
                                                                $featuredProperty->status == 1 &&
                                                                $featuredProperty->start_date != null &&
                                                                $featuredProperty->end_date != null
                                                            ) {
                                                                $featuredExpired = Carbon\Carbon::now()
                                                                    ->timezone($settings->timezone)
                                                                    ->gte(
                                                                        \Carbon\Carbon::parse(
                                                                            $featuredProperty->end_date,
                                                                        ),
                                                                    );
                                                            } else {
                                                                $featured = true;
                                                            }

                                                        ?>
                                                        <?php if(empty($featuredProperty) || $featuredExpired || $featuredProperty->payment_status == 'rejected'): ?>
                                                            <form class="d-inline-block">
                                                                <select id="featured<?php echo e($property->id); ?>"
                                                                    onchange="featuredRequest(this)"
                                                                    class="form-control <?php echo e(!empty($featuredProperty) && !$featuredExpired && $featuredProperty->status == 1 ? 'bg-success' : 'bg-danger'); ?> form-control-sm"
                                                                    data-property="<?php echo e($property->id); ?>">
                                                                    <option value="1"
                                                                        <?php echo e(empty($featuredProperty) || (!$featuredExpired && $featuredProperty->status == 1) ? 'selected' : ''); ?>>
                                                                        <?php echo e(__('Yes')); ?>

                                                                    </option>
                                                                    <option value="0"
                                                                        <?php echo e(empty($featuredProperty) || $featuredExpired || $featuredProperty->payment_status == 'rejected' ? 'selected' : ''); ?>>
                                                                        <?php echo e(__('No')); ?>

                                                                    </option>
                                                                </select>
                                                            </form>
                                                        <?php elseif($pendingfeatured): ?>
                                                            <span class="badge badge-warning btn-sm mr-1  mt-1"
                                                                href="#"> Pending </span>
                                                        <?php elseif(!empty($featuredProperty) && !$featuredExpired && !$pendingfeatured): ?>
                                                            <form id="featureForm<?php echo e($property->id); ?>"
                                                                class="d-inline-block"
                                                                action="<?php echo e(route('admin.property_management.update_featured')); ?>"
                                                                method="post">
                                                                <?php echo csrf_field(); ?>
                                                                <input type="hidden" name="requestId"
                                                                    value="<?php echo e($featuredProperty->id); ?>">

                                                                <select
                                                                    class="form-control <?php echo e($featuredProperty->status == 1 ? 'bg-success' : 'bg-danger'); ?> form-control-sm"
                                                                    name="status"
                                                                    onchange="document.getElementById('featureForm<?php echo e($property->id); ?>').submit();">
                                                                    <option value="1"
                                                                        <?php echo e($featuredProperty->status == 1 ? 'selected' : ''); ?>>
                                                                        <?php echo e(__('Yes')); ?>

                                                                    </option>
                                                                    <option value="0"
                                                                        <?php echo e($featuredProperty->status == 0 ? 'selected' : ''); ?>>
                                                                        <?php echo e(__('No')); ?>

                                                                    </option>
                                                                </select>
                                                            </form>
                                                        <?php endif; ?>


                                                    </td>

                                                    <td>
                                                        <form id="statusForm<?php echo e($property->id); ?>" class="d-inline-block"
                                                            action="<?php echo e(route('admin.property_management.update_status')); ?>"
                                                            method="post">
                                                            <?php echo csrf_field(); ?>
                                                            <input type="hidden" name="propertyId"
                                                                value="<?php echo e($property->id); ?>">

                                                            <select
                                                                class="form-control <?php echo e($property->status == 1 ? 'bg-success' : 'bg-danger'); ?> form-control-sm"
                                                                name="status"
                                                                onchange="document.getElementById('statusForm<?php echo e($property->id); ?>').submit();">
                                                                <option value="1"
                                                                    <?php echo e($property->status == 1 ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Active')); ?>

                                                                </option>
                                                                <option value="0"
                                                                    <?php echo e($property->status == 0 ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Inactive')); ?>

                                                                </option>
                                                            </select>
                                                        </form>
                                                    </td>

                                                    <td>
                                                        <div class="dropdown">
                                                            <button class="btn btn-secondary dropdown-toggle btn-sm"
                                                                type="button" id="dropdownMenuButton"
                                                                data-toggle="dropdown" aria-haspopup="true"
                                                                aria-expanded="false">
                                                                <?php echo e(__('Select')); ?>

                                                            </button>

                                                            <div class="dropdown-menu"
                                                                aria-labelledby="dropdownMenuButton">

                                                                <a class="dropdown-item"
                                                                    href="<?php echo e(route('admin.property_management.edit', $property->id)); ?>">
                                                                    <span class="btn-label">
                                                                        <i class="fas fa-edit"></i> <?php echo e(__('Edit')); ?>

                                                                    </span>
                                                                </a>

                                                                <form class="deleteForm d-inline-block p-0 dropdown-item"
                                                                    action="<?php echo e(route('admin.property_management.delete_property')); ?>"
                                                                    method="post">
                                                                    <?php echo csrf_field(); ?>
                                                                    <input type="hidden" name="property_id"
                                                                        value="<?php echo e($property->id); ?>">

                                                                    <button type="submit" class="deleteBtn">
                                                                        <span class="btn-label">
                                                                            <i class="fas fa-trash-alt"></i>
                                                                            <?php echo e(__('Delete')); ?>

                                                                        </span>
                                                                    </button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="card-footer">
                    <?php echo e($properties->appends([
                            'vendor_id' => request()->input('vendor_id'),
                            'title' => request()->input('title'),
                        ])->links()); ?>

                </div>

            </div>
        </div>
    </div>

    <div class="modal fade" id="featuredRequest" tabindex="-1" role="dialog"
        aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <form id="my-checkout-form" class="modal-form"
                    action="<?php echo e(route('admin.property_management.featured_payment')); ?>" method="post"
                    enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>

                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLongTitle"><?php echo e(__(' Featured Request')); ?></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>

                    <div class="modal-body">

                        <input type="hidden" id="in_property_id" name="property_id">


                        <div class="form-group">
                            <label for=""> <?php echo e('Select Pricing *'); ?> </label>
                            <div class="row mt-2 justify-content-center">

                                <?php $__currentLoopData = $featurePricing; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $pricing): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-md-3 ">
                                        <label class="imagecheck">
                                            <input name="featured_pricing_id" type="radio" value="<?php echo e($pricing->id); ?>"
                                                class="imagecheck-input" checked>


                                            <figure class="imagecheck-figure">

                                                <div class="card-pricing3  card-secondary ">
                                                    <div class="pricing-header  pb-2">
                                                    </div>
                                                    <div class="price-value">
                                                        <div class="value">
                                                            <span
                                                                class="amount"><?php echo e($pricing->price == 0 ? 'Free' : symbolPrice($pricing->price)); ?></span>
                                                        </div>
                                                    </div>

                                                    <ul class="pricing-content">
                                                        <li><?php echo e(__('Number Of Days') . ' :'); ?>

                                                            <?php echo e($pricing->number_of_days); ?></li>
                                                    </ul>
                                                </div>
                                            </figure>
                                        </label>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </div>
                        </div>


                        <div class="form-group mb-2">
                            <label for="payment-gateway"> <?php echo e(__('Select Payment Method *')); ?></label>
                            <select name="gateway" id="payment-gateway" required class="form-control select">
                                <option selected disabled value="">
                                    <?php echo e(__('Select Payment Gateway')); ?>

                                </option>
                                <?php if(count($onlineGateways) > 0): ?>
                                    <?php $__currentLoopData = $onlineGateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $onlineGateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($onlineGateway->keyword); ?>"
                                            <?php echo e($onlineGateway->keyword == old('gateway') ? 'selected' : ''); ?>>
                                            <?php echo e($onlineGateway->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>

                                <?php if(count($offlineGateways) > 0): ?>
                                    <?php $__currentLoopData = $offlineGateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $offlineGateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($offlineGateway->name); ?>"
                                            <?php echo e($offlineGateway->name == old('gateway') ? 'selected' : ''); ?>>
                                            <?php echo e($offlineGateway->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </select>
                            <?php if($errors->has('payment_method')): ?>
                                <span class="method-error">
                                    <strong><?php echo e($errors->first('payment_method')); ?></strong>
                                </span>
                            <?php endif; ?>
                        </div>

                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary " data-dismiss="modal">
                            <?php echo e(__('Close')); ?>

                        </button>
                        <button type="submit" id="paymentAdmin" class="btn btn-primary ">
                            <?php echo e(__('Pay')); ?>

                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        "use strict";
        var stripe_key = "";
    </script>
    <script src="<?php echo e(asset('assets/js/feature-payment.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\creabiz\paradox\resources\views/backend/property/index.blade.php ENDPATH**/ ?>