


<?php if ($__env->exists('backend.partials.rtl-style')) echo $__env->make('backend.partials.rtl-style', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->startSection('content'); ?>
    <div class="page-header">
        <h4 class="page-title"><?php echo e(__('Project Types')); ?></h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="<?php echo e(route('admin.dashboard')); ?>">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#"><?php echo e(__('Property Management')); ?></a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#"><?php echo e(__('Project Types')); ?></a>
            </li>
        </ul>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card-title d-inline-block"><?php echo e(__('Project Types')); ?></div>
                        </div>

                        <div class="col-lg-3">
                            <?php if ($__env->exists('backend.partials.languages')) echo $__env->make('backend.partials.languages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>

                        <div class="col-lg-4 offset-lg-1 mt-2 mt-lg-0">
                            <a href="#" data-toggle="modal" data-target="#createModal"
                                class="btn btn-primary btn-sm float-lg-right float-left"><i class="fas fa-plus"></i>
                                <?php echo e(__('Add Project Type')); ?></a>

                            <button class="btn btn-danger btn-sm float-right mr-2 d-none bulk-delete"
                                data-href="<?php echo e(route('admin.project_management.bulk_delete_type')); ?>">
                                <i class="flaticon-interface-5"></i> <?php echo e(__('Delete')); ?>

                            </button>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-12">
                            <?php if(count($types) == 0): ?>
                                <h3 class="text-center mt-2"><?php echo e(__('NO PROPERTY TYPES FOUND') . '!'); ?></h3>
                            <?php else: ?>
                                <div class="table-responsive">
                                    <table class="table table-striped mt-3" id="basic-datatables">
                                        <thead>
                                            <tr>
                                                <th scope="col">
                                                    <input type="checkbox" class="bulk-check" data-val="all">
                                                </th>

                                                <th scope="col"><?php echo e(__('Name')); ?></th>
                                                <th scope="col">
                                                    <?php echo e(__('Min Price') . ' (' . $settings->base_currency_text . ')'); ?>

                                                </th>
                                                <th scope="col"><?php echo e(__('Min Area (sqft)')); ?></th>
                                                <th scope="col"><?php echo e(__('Total Unit')); ?></th>
                                                <th scope="col"><?php echo e(__('Actions')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td>
                                                        <input type="checkbox" class="bulk-check"
                                                            data-val="<?php echo e($type->id); ?>">
                                                    </td>
                                                    <?php
                                                        $typeContnent = $type
                                                            ->projectTypeContnents()
                                                            ->where('language_id', $language->id)
                                                            ->first();
                                                    ?>
                                                    <td>
                                                        
                                                        <?php echo e(strlen($typeContnent->name) > 50 ? mb_substr($typeContnent->name, 0, 50, 'UTF-8') . '...' : $typeContnent->name); ?>

                                                    </td>
                                                    <td>
                                                        <?php echo e(symbolPrice($typeContnent->min_price)); ?>

                                                    </td>
                                                    <td>
                                                        <?php echo e($typeContnent->min_area); ?>

                                                    </td>
                                                    <td>
                                                        <?php echo e($typeContnent->unit); ?>

                                                    </td>

                                                    <td>
                                                        <a class="btn btn-secondary btn-sm mr-1  mt-1 editBtn"
                                                            href="#" data-toggle="modal" data-target="#editModal"
                                                            data-id="<?php echo e($type->id); ?>"
                                                            data-vendor_id="<?php echo e($vendor_id); ?>"
                                                            data-project_id="<?php echo e($type->project_id); ?>"
                                                            <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
                                                            <?php
                                                                $projectType = \App\Models\Project\ProjectTypeContent::where([['language_id',$lang->id] ,['project_type_id',$type->id]])->first(); 
                                                            ?>
                                                            
                                                            data-<?php echo e($lang->code); ?>_name="<?php echo e(@$projectType->name); ?>"
                                                            data-<?php echo e($lang->code); ?>_min_area="<?php echo e(@$projectType->min_area); ?>"
                                                            data-<?php echo e($lang->code); ?>_max_area="<?php echo e(@$projectType->max_area); ?>"
                                                            data-<?php echo e($lang->code); ?>_min_price="<?php echo e(@$projectType->min_price); ?>"
                                                            data-<?php echo e($lang->code); ?>_max_price="<?php echo e(@$projectType->max_price); ?>"
                                                            data-<?php echo e($lang->code); ?>_unit="<?php echo e(@$projectType->unit); ?>" <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>>
                                                            <span class="btn-label">
                                                                <i class="fas fa-edit"></i>
                                                            </span>
                                                        </a>

                                                        <form class="deleteForm d-inline-block"
                                                            action="<?php echo e(route('admin.project_management.delete_type')); ?>"
                                                            method="post">
                                                            <?php echo csrf_field(); ?>
                                                            <input type="hidden" name="id"
                                                                value="<?php echo e($type->id); ?>">

                                                            <button type="submit"
                                                                class="btn btn-danger  mt-1 btn-sm deleteBtn">
                                                                <span class="btn-label">
                                                                    <i class="fas fa-trash"></i>
                                                                </span>
                                                            </button>
                                                        </form>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="card-footer"></div>
            </div>
        </div>
    </div>

    
    <?php echo $__env->make('backend.project.type.create', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    
    <?php echo $__env->make('backend.project.type.edit', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script type="text/javascript" src="<?php echo e(asset('assets/js/admin-partial.js')); ?>"></script>
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\CreaBiz\paradox\resources\views/backend/project/type/index.blade.php ENDPATH**/ ?>