


<?php if ($__env->exists('backend.partials.rtl-style')) echo $__env->make('backend.partials.rtl-style', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->startSection('content'); ?>
    <div class="page-header">
        <h4 class="page-title"><?php echo e(__('Testimonial Section')); ?></h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="<?php echo e(route('admin.dashboard')); ?>">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#"><?php echo e(__('Home Page')); ?></a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#"><?php echo e(__('Testimonial Section')); ?></a>
            </li>
        </ul>
    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="row">
                <?php if($settings->theme_version != 3): ?>
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="card-title"><?php echo e(__('Update Testimonial Section Backgroud Image')); ?></div>
                                    </div>
                                </div>
                            </div>

                            <div class="card-body">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <form id="testimonialFormBg"
                                            action="<?php echo e(route('admin.home_page.update_testimonial_section_background', ['language' => request()->input('language')])); ?>"
                                            method="POST" enctype="multipart/form-data">
                                            <?php echo csrf_field(); ?>
                                            <div class="row">
                                                <div class="col">
                                                    <div class="form-group">
                                                        <label for=""><?php echo e(__('Image') . '*'); ?></label>
                                                        <br>
                                                        <div class="thumb-preview">
                                                            <?php if(@$themeInfo->testimonial_section_image != null): ?>
                                                                <img src="<?php echo e(asset('assets/img/' . $themeInfo->testimonial_section_image)); ?>"
                                                                    alt="..."class="uploaded-img">
                                                            <?php else: ?>
                                                                <img src="<?php echo e(asset('assets/img/noimage.jpg')); ?>"
                                                                    alt="..." class="uploaded-img">
                                                            <?php endif; ?>
                                                        </div>

                                                        <div class="mt-3">
                                                            <div role="button" class="btn btn-primary btn-sm upload-btn">
                                                                <?php echo e(__('Choose Image')); ?>

                                                                <input type="file" class="img-input"
                                                                    name="testimonial_section_image">
                                                            </div>
                                                        </div>
                                                        <p id="err_testimonial_section_image"
                                                            class="mt-2 mb-0 text-danger em">
                                                        </p>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>

                            <div class="card-footer">
                                <div class="row">
                                    <div class="col-12 text-center">
                                        <button type="submit" form="testimonialFormBg" class="btn btn-success">
                                            <?php echo e(__('Update')); ?>

                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-lg-10">
                                    <div class="card-title"><?php echo e(__('Update Testimonial Section')); ?></div>
                                </div>

                                <div class="col-lg-2">
                                    <?php if ($__env->exists('backend.partials.languages')) echo $__env->make('backend.partials.languages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            </div>
                        </div>

                        <div class="card-body">
                            <div class="row">
                                <div class="col-lg-12">
                                    <form id="testimonialForm"
                                        action="<?php echo e(route('admin.home_page.update_testimonial_section', ['language' => request()->input('language')])); ?>"
                                        method="POST" enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>


                                        <div class="row">
                                            <div class="col">
                                                <div class="form-group">
                                                    <label for=""><?php echo e(__('Title')); ?></label>
                                                    <input type="text" class="form-control" name="title"
                                                        value="<?php echo e(empty($data->title) ? '' : $data->title); ?>"
                                                        placeholder="Enter Title">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col">
                                                <div class="form-group">
                                                    <label for=""><?php echo e(__('Subtitle')); ?></label>
                                                    <input type="text" class="form-control" name="subtitle"
                                                        value="<?php echo e(empty($data->subtitle) ? '' : $data->subtitle); ?>"
                                                        placeholder="Enter Subtitle">
                                                </div>
                                            </div>
                                        </div>
                                        <?php if($settings->theme_version != 3): ?>
                                            <div class="row">
                                                <div class="col">
                                                    <div class="form-group">
                                                        <label for=""><?php echo e(__('Content')); ?></label>
                                                        <textarea class="form-control" name="content" placeholder="Enter content" rows="3"><?php echo e(empty($data->content) ? '' : $data->content); ?></textarea>

                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <div class="card-footer">
                            <div class="row">
                                <div class="col-12 text-center">
                                    <button type="submit" form="testimonialForm" class="btn btn-success">
                                        <?php echo e(__('Update')); ?>

                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card-title"><?php echo e(__('Testimonials')); ?></div>
                        </div>

                        <div class="col-lg-3">
                            <?php if ($__env->exists('backend.partials.languages')) echo $__env->make('backend.partials.languages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>

                        <div class="col-lg-4 offset-lg-1 mt-2 mt-lg-0">
                            <a href="#" data-toggle="modal" data-target="#createModal"
                                class="btn btn-primary btn-sm float-lg-right float-left"><i class="fas fa-plus"></i>
                                <?php echo e(__('Add')); ?></a>

                            <button class="btn btn-danger btn-sm float-right mr-2 d-none bulk-delete"
                                data-href="<?php echo e(route('admin.home_page.bulk_delete_testimonial')); ?>">
                                <i class="flaticon-interface-5"></i> <?php echo e(__('Delete')); ?>

                            </button>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col">
                            <?php if(count($testimonials) == 0): ?>
                                <h3 class="text-center mt-2"><?php echo e(__('NO TESTIMONIAL FOUND') . '!'); ?></h3>
                            <?php else: ?>
                                <div class="table-responsive">
                                    <table class="table table-striped mt-3" id="basic-datatables">
                                        <thead>
                                            <tr>
                                                <th scope="col">
                                                    <input type="checkbox" class="bulk-check" data-val="all">
                                                </th>

                                                <?php if($themeInfo->theme_version == 2): ?>
                                                    <th scope="col"><?php echo e(__('Image')); ?></th>
                                                <?php endif; ?>

                                                <th scope="col"><?php echo e(__('Name')); ?></th>
                                                <th scope="col"><?php echo e(__('Occupation')); ?></th>
                                                <th scope="col"><?php echo e(__('Actions')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td>
                                                        <input type="checkbox" class="bulk-check"
                                                            data-val="<?php echo e($testimonial->id); ?>">
                                                    </td>

                                                    <?php if($themeInfo->theme_version == 2): ?>
                                                        <td>
                                                            <?php if(is_null($testimonial->image)): ?>
                                                                -
                                                            <?php else: ?>
                                                                <img src="<?php echo e(asset('assets/img/clients/' . $testimonial->image)); ?>"
                                                                    alt="client image" width="45">
                                                            <?php endif; ?>
                                                        </td>
                                                    <?php endif; ?>

                                                    <td><?php echo e($testimonial->name); ?></td>
                                                    <td><?php echo e($testimonial->occupation); ?></td>

                                                    <td>
                                                        <div class="dropdown">
                                                            <button class="btn btn-secondary dropdown-toggle btn-sm"
                                                                type="button" id="dropdownMenuButton"
                                                                data-toggle="dropdown" aria-haspopup="true"
                                                                aria-expanded="false">
                                                                <?php echo e(__('Select')); ?>

                                                            </button>

                                                            <div class="dropdown-menu"
                                                                aria-labelledby="dropdownMenuButton">

                                                                <a class=" dropdown-item editBtn" href="#"
                                                                    data-toggle="modal" data-target="#editModal"
                                                                    data-id="<?php echo e($testimonial->id); ?>"
                                                                    data-image="<?php echo e(is_null($testimonial->image) ? asset('assets/img/noimage.jpg') : asset('assets/img/clients/' . $testimonial->image)); ?>"
                                                                    data-name="<?php echo e($testimonial->name); ?>"
                                                                    data-occupation="<?php echo e($testimonial->occupation); ?>"
                                                                    data-rating="<?php echo e($testimonial->rating); ?>"
                                                                    data-comment="<?php echo e($testimonial->comment); ?>">
                                                                    <span class="btn-label">
                                                                        <i class="fas fa-edit"></i>
                                                                        <?php echo e(__('Edit')); ?>

                                                                    </span>
                                                                </a>

                                                                <form class="deleteForm d-block dropdown-item p-0"
                                                                    action="<?php echo e(route('admin.home_page.delete_testimonial', ['id' => $testimonial->id])); ?>"
                                                                    method="post">
                                                                    <?php echo csrf_field(); ?>
                                                                    <button type="submit" class=" deleteBtn">
                                                                        <span class="btn-label">
                                                                            <i class="fas fa-trash"></i>
                                                                            <?php echo e(__('Delete')); ?>

                                                                        </span>
                                                                    </button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="card-footer"></div>
            </div>
        </div>
    </div>

    
    <?php echo $__env->make('backend.home-page.testimonial-section.create', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    
    <?php echo $__env->make('backend.home-page.testimonial-section.edit', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\creabiz\paradox\resources\views/backend/home-page/testimonial-section/index.blade.php ENDPATH**/ ?>