


<?php if ($__env->exists('backend.partials.rtl-style')) echo $__env->make('backend.partials.rtl-style', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->startSection('content'); ?>
    <div class="page-header">
        <h4 class="page-title"><?php echo e(__('Cities')); ?></h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="<?php echo e(route('admin.dashboard')); ?>">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#"><?php echo e(__('Property Specifications')); ?></a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#"><?php echo e(__('Cities')); ?></a>
            </li>
        </ul>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card-title d-inline-block"><?php echo e(__('Cities')); ?></div>
                        </div>

                        <div class="col-lg-3">
                            <?php if ($__env->exists('backend.partials.languages')) echo $__env->make('backend.partials.languages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>

                        <div class="col-lg-4 offset-lg-1 mt-2 mt-lg-0">
                            <a href="#" data-toggle="modal" data-target="#createModal"
                                class="btn btn-primary btn-sm float-lg-right float-left"><i class="fas fa-plus"></i>
                                <?php echo e(__('Add')); ?></a>

                            <button class="btn btn-danger btn-sm float-right mr-2 d-none bulk-delete"
                                data-href="<?php echo e(route('admin.property_specification.bulk_delete_city')); ?>">
                                <i class="flaticon-interface-5"></i> <?php echo e(__('Delete')); ?>

                            </button>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-12">
                            <?php if(count($cities) == 0): ?>
                                <h3 class="text-center mt-2"><?php echo e(__('NO CITY FOUND') . '!'); ?></h3>
                            <?php else: ?>
                                <div class="table-responsive">
                                    <table class="table table-striped mt-3" id="basic-datatables">
                                        <thead>
                                            <tr>
                                                <th scope="col">
                                                    <input type="checkbox" class="bulk-check" data-val="all">
                                                </th>
                                                <?php if($settings->property_country_status == 1): ?>
                                                    <th scope="col"><?php echo e(__('Country Name')); ?></th>
                                                <?php endif; ?>
                                                <?php if($settings->property_state_status == 1): ?>
                                                    <th scope="col"><?php echo e(__('State Name')); ?></th>
                                                <?php endif; ?>
                                                <th scope="col"><?php echo e(__('City Name')); ?></th>
                                                <?php if($settings->theme_version == 1): ?>
                                                    <th scope="col"><?php echo e(__('Featured')); ?></th>
                                                <?php endif; ?>
                                                <th scope="col"><?php echo e(__('Status')); ?></th>
                                                <th scope="col"><?php echo e(__('Serial Number')); ?></th>
                                                <th scope="col"><?php echo e(__('Actions')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td>
                                                        <input type="checkbox" class="bulk-check"
                                                            data-val="<?php echo e($city->id); ?>">
                                                    </td>
                                                    <?php if($settings->property_country_status == 1): ?>
                                                        <td>
                                                            <?php echo e(strlen($city->country?->getContent($language->id)?->name) > 50 ? mb_substr($city->country?->getContent($language->id)?->name, 0, 50, 'UTF-8') . '...' : $city->country?->getContent($language->id)?->name); ?>

                                                        </td>
                                                    <?php endif; ?>
                                                    <?php if($settings->property_state_status == 1): ?>
                                                        <td>
                                                            <?php if(!is_null($city->state)): ?>
                                                                <?php echo e(strlen($city->state?->getContent($language->id)?->name) > 50 ? mb_substr($city->state?->getContent($language->id)?->name, 0, 50, 'UTF-8') . '...' : $city->state?->getContent($language->id)?->name); ?>

                                                            <?php else: ?>
                                                                -
                                                            <?php endif; ?>
                                                        </td>
                                                    <?php endif; ?>
                                                    <td>
                                                        <?php echo e(strlen($city->name) > 50 ? mb_substr($city->name, 0, 50, 'UTF-8') . '...' : $city->name); ?>

                                                    </td>
                                                    <?php if($settings->theme_version == 1): ?>
                                                        <td>

                                                            <form id="featureForm<?php echo e($city->id); ?>"
                                                                class="d-inline-block"
                                                                action="<?php echo e(route('admin.property_specification.update_featured')); ?>"
                                                                method="post">
                                                                <?php echo csrf_field(); ?>
                                                                <input type="hidden" name="cityId"
                                                                    value="<?php echo e($city->id); ?>">

                                                                <select
                                                                    class="form-control <?php echo e($city->featured == 1 ? 'bg-success' : 'bg-danger'); ?> form-control-sm"
                                                                    name="featured"
                                                                    onchange="document.getElementById('featureForm<?php echo e($city->id); ?>').submit();">
                                                                    <option value="1"
                                                                        <?php echo e($city->featured == 1 ? 'selected' : ''); ?>>
                                                                        <?php echo e(__('Yes')); ?>

                                                                    </option>
                                                                    <option value="0"
                                                                        <?php echo e($city->featured == 0 ? 'selected' : ''); ?>>
                                                                        <?php echo e(__('No')); ?>

                                                                    </option>
                                                                </select>
                                                            </form>

                                                        </td>
                                                    <?php endif; ?>
                                                    <td>
                                                        <?php if($city->status == 1): ?>
                                                            <h2 class="d-inline-block"><span
                                                                    class="badge badge-success"><?php echo e(__('Active')); ?></span>
                                                            </h2>
                                                        <?php else: ?>
                                                            <h2 class="d-inline-block"><span
                                                                    class="badge badge-danger"><?php echo e(__('Inactive')); ?></span>
                                                            </h2>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td><?php echo e($city->serial_number); ?></td>
                                                    <td>
                                                        <div class="dropdown">
                                                            <button class="btn btn-secondary dropdown-toggle btn-sm"
                                                                type="button" id="dropdownMenuButton"
                                                                data-toggle="dropdown" aria-haspopup="true"
                                                                aria-expanded="false">
                                                                <?php echo e(__('Select')); ?>

                                                            </button>

                                                            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">

                                                                <a class="dropdown-item editBtn" href="#"
                                                                    data-toggle="modal" data-target="#editModal"
                                                                    data-id="<?php echo e($city->id); ?>"
                                                                    <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php
                                                                
                                                                $cit = \App\Models\Property\CityContent::where([["city_id",$city->id],['language_id',$lang->id]])->first();
                                                            ?>  
                                                            data-<?php echo e($lang->code); ?>_name="<?php echo e($cit?->name); ?>" <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    data-status="<?php echo e($city->status); ?>"
                                                                    data-image="<?php echo e(asset('assets/img/property-city/' . $city->image)); ?>"
                                                                    data-serial_number="<?php echo e($city->serial_number); ?>">
                                                                    <span class="btn-label">
                                                                        <i class="fas fa-edit"></i> <?php echo e(__('Edit')); ?>

                                                                    </span>
                                                                </a>

                                                                <form class="deleteForm d-inline-block dropdown-item"
                                                                    action="<?php echo e(route('admin.property_specification.delete_city')); ?>"
                                                                    method="post">
                                                                    <?php echo csrf_field(); ?>
                                                                    <input type="hidden" name="id"
                                                                        value="<?php echo e($city->id); ?>">

                                                                    <button type="submit" class="p-0 deleteBtn">
                                                                        <span class="btn-label">
                                                                            <i class="fas fa-trash-alt"></i>
                                                                            <?php echo e(__('Delete')); ?>

                                                                        </span>
                                                                    </button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="card-footer"></div>
            </div>
        </div>
    </div>

    
    <?php echo $__env->make('backend.property.city.create', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    
    <?php echo $__env->make('backend.property.city.edit', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        let countryStatus = <?php echo e($settings->property_country_status); ?> == 1 ? true : false;
        let stateStatus = <?php echo e($settings->property_state_status); ?> == 1 ? true : false;
        let stateUrl = "<?php echo e(route('admin.property_specification.get_state')); ?>";
    </script>
    <script type="text/javascript" src="<?php echo e(asset('assets/js/admin-city.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\creabiz\paradox\resources\views/backend/property/city/index.blade.php ENDPATH**/ ?>