<?php
    $version = $basicInfo->theme_version;
?>


<?php $__env->startSection('pageHeading'); ?>
    <?php if(!empty($pageHeading)): ?>
        <?php echo e($pageHeading->blog_page_title); ?>

    <?php else: ?>
        <?php echo e(__('Posts')); ?>

    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('metaKeywords'); ?>
    <?php if(!empty($seoInfo)): ?>
        <?php echo e($seoInfo->meta_keyword_blog); ?>

    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('metaDescription'); ?>
    <?php if(!empty($seoInfo)): ?>
        <?php echo e($seoInfo->meta_description_blog); ?>

    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php if ($__env->exists('frontend.partials.breadcrumb', [
        'breadcrumb' => $bgImg->breadcrumb,
        'title' => !empty($pageHeading) ? $pageHeading->blog_page_title : __('Blog'),
        'subtitle' => __('Blog'),
    ])) echo $__env->make('frontend.partials.breadcrumb', [
        'breadcrumb' => $bgImg->breadcrumb,
        'title' => !empty($pageHeading) ? $pageHeading->blog_page_title : __('Blog'),
        'subtitle' => __('Blog'),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="blog-area pt-100 pb-70">
        <div class="container">
            <div class="row justify-content-center">
                <?php if(count($blogs) == 0): ?>
                    <div class="col-lg-12">

                        <h3 class="text-center mt-3"><?php echo e(__('No Post Found') . '!'); ?></h3>
                    </div>
                <?php else: ?>
                    <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-6 col-lg-4" data-aos="fade-up" data-aos-delay="100">
                            <article class="card mb-30">
                                <div class="card-image">
                                    <a href="<?php echo e(route('blog_details', ['slug' => $blog->slug])); ?>"
                                        class="lazy-container ratio ratio-16-9">
                                        <img class="lazyload" src="<?php echo e(asset('assets/front/images/placeholder.png')); ?>"
                                            data-src="<?php echo e(asset('assets/img/blogs/' . $blog->image)); ?>">
                                    </a>
                                    <a href="<?php echo e(route('blog', ['category' => $blog->categorySlug])); ?>"> <span
                                            class="tag"><?php echo e($blog->categoryName); ?></span></a>
                                </div>
                                <div class="content">
                                    <ul class="info-list justify-content-around">
                                        <li><i class="fal fa-user"></i><?php echo e($blog->author); ?></li>
                                        <li><i class="fal fa-calendar"></i>
                                            <?php echo e(Carbon\Carbon::parse($blog->created_at)->format('d M Y')); ?>

                                        </li>

                                    </ul>
                                    <h3 class="card-title">
                                        <a href="<?php echo e(route('blog_details', ['slug' => $blog->slug])); ?>">
                                            <?php echo e(@$blog->title); ?>

                                        </a>
                                    </h3>
                                    <p class="card-text">
                                        <?php echo e(strlen(strip_tags($blog->content)) > 90 ? mb_substr(strip_tags($blog->content), 0, 90, 'UTF-8') . '...' : strip_tags($blog->content)); ?>

                                    </p>
                                    <a href="<?php echo e(route('blog_details', ['slug' => $blog->slug])); ?>"
                                        class="card-btn"><?php echo e(__('Read More')); ?></a>
                                </div>
                            </article>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
                <?php if(!empty(showAd(3))): ?>
                    <div class="text-center mt-4">
                        <?php echo showAd(3); ?>

                    </div>
                <?php endif; ?>
            </div>
            <div class="pagination mb-30 justify-content-center" data-aos="fade-up">
                <?php echo e($blogs->links()); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("frontend.layouts.layout-v$version", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\CreaBiz\paradox\resources\views/frontend/journal/blog.blade.php ENDPATH**/ ?>