

<?php $__env->startSection('content'); ?>
    <div class="page-header">
        <h4 class="page-title"><?php echo e(__('Add Poperty')); ?></h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="<?php echo e(route('admin.dashboard')); ?>">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#"><?php echo e(__('Porperty Management')); ?></a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#"><?php echo e(__('Add Porperty')); ?><?php if(request('type') == 'residential'): ?>
                       <?php echo e("(Residential)"); ?>

                    <?php else: ?>
                        <?php echo e("(Commercial)"); ?>

                    <?php endif; ?>
                </a>
            </li>
        </ul>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="card-title d-inline-block"><?php echo e(__('Add Porperty')); ?></div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-10 offset-lg-1">
                            <div class="alert alert-danger pb-1 dis-none" id="carErrors">
                                <button type="button" class="close" data-dismiss="alert">×</button>
                                <ul></ul>
                            </div>
                            <div class="col-lg-12">
                                <label for="" class="mb-2"><strong><?php echo e(__('Gallery Images')); ?> **</strong></label>
                                <form action="<?php echo e(route('admin.property.imagesstore')); ?>" id="my-dropzone"
                                    enctype="multipart/form-data" class="dropzone create">
                                    <?php echo csrf_field(); ?>
                                    <div class="fallback">
                                        <input name="file" type="file" multiple />
                                    </div>
                                </form>
                                <p class="em text-danger mb-0" id="errslider_images"></p>
                            </div>
                            <form id="carForm" action="<?php echo e(route('admin.property_management.store_property')); ?>"
                                method="POST" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="type" value="<?php echo e(request()->type); ?>">
                                <div id="sliders"></div>
                                <div class="row">
                                    <div class="col-lg-4">
                                        <div class="form-group">
                                            <label for=""><?php echo e(__('Thumbnail Image') . '*'); ?></label>
                                            <br>
                                            <div class="thumb-preview ">
                                                <img src="<?php echo e(asset('assets/img/noimage.jpg')); ?>" alt="..."
                                                    class="uploaded-img">

                                            </div>

                                            <div class="mt-3">
                                                <div role="button" class="btn btn-primary btn-sm upload-btn">
                                                    <?php echo e(__('Choose Image')); ?>

                                                    <input type="file" class="img-input" name="featured_image">
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-lg-4">
                                        <div class="form-group">
                                            <label for=""><?php echo e(__('Floor Planning Image')); ?></label>
                                            <br>
                                            <div class="thumb-preview remove">
                                                <img src="<?php echo e(asset('assets/img/noimage.jpg')); ?>" alt="..."
                                                    class="uploaded-img2">

                                            </div>

                                            <div class="mt-3">
                                                <div role="button" class="btn btn-primary btn-sm upload-btn">
                                                    <?php echo e(__('Choose Image')); ?>

                                                    <input type="file" class="img-input2" name="floor_planning_image">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <div class="form-group">
                                            <label for=""><?php echo e(__('Video Image')); ?></label>
                                            <br>
                                            <div class="thumb-preview remove">
                                                <img src="<?php echo e(asset('assets/img/noimage.jpg')); ?>" alt="..."
                                                    class="uploaded-img3">

                                            </div>

                                            <div class="mt-3">
                                                <div role="button" class="btn btn-primary btn-sm upload-btn">
                                                    <?php echo e(__('Choose Image')); ?>

                                                    <input type="file" class="img-input3" name="video_image">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label><?php echo e(__('Video Url')); ?> </label>
                                            <input type="text" class="form-control" name="video_url"
                                                placeholder="Enter video url">
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label><?php echo e(__('Purpose')); ?>*</label>

                                            <select name="purpose" class="form-control">
                                                <option selected disabled value=""> <?php echo e(__('Select a Purpose')); ?>

                                                </option>
                                                <option value="rent"><?php echo e(__('Rent')); ?></option>
                                                <option value="sale"><?php echo e(__('Sale')); ?></option>
                                            </select>
                                        </div>

                                    </div>
                                    <div class="col-lg-3">
                                        <div class="form-group ">
                                            <label><?php echo e(__('Category')); ?> *</label>
                                            <select name="category_id" class="form-control category">
                                                <option disabled selected>
                                                    <?php echo e(__('Select a Category')); ?>

                                                </option>

                                                <?php $__currentLoopData = $propertyCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($category->id); ?>">
                                                        <?php echo e($category->categoryContent->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                    <?php if($propertySettings->property_country_status == 1): ?>
                                        <div class="col-lg-3">
                                            <div class="form-group">


                                                <label><?php echo e(__('Country')); ?> *</label>
                                                <select name="country_id"
                                                    class="form-control country js-example-basic-single3">
                                                    <option disabled selected><?php echo e(__('Select Country')); ?>

                                                    </option>

                                                    <?php $__currentLoopData = $propertyCountries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($country->id); ?>">
                                                            <?php echo e($country->countryContent->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    <?php if($propertySettings->property_state_status == 1): ?>
                                        <div class="col-lg-3 state">
                                            <div class="form-group  ">

                                                <label><?php echo e(__('State')); ?> *</label>
                                                <select onchange="getCities(event)" name="state_id"
                                                    class="form-control state_id states js-example-basic-single3">
                                                    <option selected disabled><?php echo e(__('Select State')); ?>

                                                    </option>
                                                    <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($state->id); ?>">
                                                            <?php echo e($state->stateContent->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </select>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    <div class="col-lg-3 city">
                                        <div class="form-group ">


                                            <label><?php echo e(__('City')); ?> *</label>
                                            <select name="city_id" class="form-control city_id js-example-basic-single3">
                                                <option selected disabled><?php echo e(__('Select City')); ?>

                                                </option>
                                                <?php if($propertySettings->property_state_status == 0 && $propertySettings->property_country_status == 0): ?>
                                                    <?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($city->id); ?>">
                                                            <?php echo e($city->cityContent->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label for=""><?php echo e(__('Amenities')); ?>*</label>
                                            <select name="amenities[]" class="form-control js-example-basic-single2"
                                                multiple="multiple">
                                                <option value="" disabled>
                                                    <?php echo e(__('Please Select Amenities')); ?>

                                                </option>
                                                <?php $__currentLoopData = $amenities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $amenity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($amenity->id); ?>">
                                                        <?php echo e($amenity->amenityContent->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>

                                        </div>
                                    </div>

                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label><?php echo e(__('Price') . ' (' . $settings->base_currency_text . ')'); ?> </label>
                                            <input type="number" class="form-control" name="price"
                                                placeholder="Enter Current Price">

                                            <p class="text-warning">
                                                <?php echo e(__('If you leave it blank, price will be negotiable.')); ?>

                                            </p>
                                        </div>
                                    </div>

                                    <?php if(request('type') == 'residential'): ?>
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label><?php echo e(__('Beds')); ?> *</label>
                                                <input type="text" class="form-control" name="beds"
                                                    placeholder="Enter number of bed">
                                            </div>
                                        </div>
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label><?php echo e(__('Baths')); ?> *</label>
                                                <input type="text" class="form-control" name="bath"
                                                    placeholder="Enter number of bath">
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label><?php echo e(__('Area (sqft)')); ?> *</label>
                                            <input type="text" class="form-control" name="area"
                                                placeholder="Enter area (sqft) ">
                                        </div>
                                    </div>

                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label><?php echo e(__('Status')); ?> *</label>
                                            <select name="status" id="" class="form-control">
                                                <option value="1"><?php echo e(__('Active')); ?></option>
                                                <option value="0"><?php echo e(__('Inactive')); ?></option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label><?php echo e(__('Latitude')); ?> * </label>
                                            <input type="text" class="form-control" name="latitude"
                                                placeholder="Enter Latitude">
                                        </div>
                                    </div>

                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label><?php echo e(__('Longitude')); ?> * </label>
                                            <input type="text" class="form-control" name="longitude"
                                                placeholder="Enter Longitude">
                                        </div>
                                    </div>

                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label for=""><?php echo e(__('Vendor')); ?></label>
                                            <select name="vendor_id" class="form-control vendor js-example-basic-single1">
                                                <option value="0" selected><?php echo e(__('Please Select')); ?>

                                                </option>
                                                <?php $__currentLoopData = $vendors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vendor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($vendor->id); ?>"><?php echo e($vendor->username); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <p class="text-warning">
                                                <?php echo e(__('if you do not select any vendor, then this property will be listed under you')); ?>

                                            </p>
                                        </div>
                                    </div>

                                    <div class="col-lg-3">
                                        <div class="form-group agent d-none">
                                            <label for=""><?php echo e(__('Agent')); ?></label>
                                            <select name="agent_id"
                                                class="form-control agent_id js-example-basic-single1">
                                                <option value="" selected><?php echo e(__('Please Select')); ?>

                                                </option> 
                                            </select>
                                            <p class="text-warning">
                                                <?php echo e(__('if you do not select any agent, then this property will be listed under Vendor')); ?>

                                            </p>
                                        </div>
                                    </div>



                                </div>

                                <div id="accordion" class="mt-3">
                                    <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="version">
                                            <div class="version-header" id="heading<?php echo e($language->id); ?>">
                                                <h5 class="mb-0">
                                                    <button type="button" class="btn btn-link" data-toggle="collapse"
                                                        data-target="#collapse<?php echo e($language->id); ?>"
                                                        aria-expanded="<?php echo e($language->is_default == 1 ? 'true' : 'false'); ?>"
                                                        aria-controls="collapse<?php echo e($language->id); ?>">
                                                        <?php echo e($language->name . __(' Language')); ?>

                                                        <?php echo e($language->is_default == 1 ? '(Default)' : ''); ?>

                                                    </button>
                                                </h5>
                                            </div>

                                            <div id="collapse<?php echo e($language->id); ?>"
                                                class="collapse <?php echo e($language->is_default == 1 ? 'show' : ''); ?>"
                                                aria-labelledby="heading<?php echo e($language->id); ?>" data-parent="#accordion">
                                                <div class="version-body">
                                                    <div class="row">
                                                        <div class="col-lg-12">
                                                            <div
                                                                class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                <label><?php echo e(__('Title')); ?> *</label>
                                                                <input type="text" class="form-control"
                                                                    name="<?php echo e($language->code); ?>_title"
                                                                    placeholder="Enter Title">
                                                            </div>
                                                        </div>




                                                        <div class="col-lg-12">
                                                            <div
                                                                class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                <label><?php echo e(__('Address') . '*'); ?></label>
                                                                <input type="text"
                                                                    name="<?php echo e($language->code); ?>_address"
                                                                    class="form-control" placeholder="Enter Address">
                                                            </div>
                                                        </div>

                                                    </div>

                                                    <div class="row">
                                                        <div class="col-lg-12">
                                                            <div
                                                                class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                <label><?php echo e(__('Description')); ?> *</label>
                                                                <textarea id="<?php echo e($language->code); ?>_description" class="form-control summernote"
                                                                    name="<?php echo e($language->code); ?>_description" data-height="300"></textarea>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="row">
                                                        <div class="col-lg-12">
                                                            <div
                                                                class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                <label><?php echo e(__('Meta Keywords')); ?> *</label>
                                                                <input class="form-control"
                                                                    name="<?php echo e($language->code); ?>_meta_keyword"
                                                                    placeholder="Enter Meta Keywords"
                                                                    data-role="tagsinput">
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="row">
                                                        <div class="col-lg-12">
                                                            <div
                                                                class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                <label><?php echo e(__('Meta Description')); ?> *</label>
                                                                <textarea class="form-control" name="<?php echo e($language->code); ?>_meta_description" rows="5"
                                                                    placeholder="Enter Meta Description"></textarea>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="row">
                                                        <div class="col">
                                                            <?php $currLang = $language; ?>

                                                            <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php if($language->id == $currLang->id) continue; ?>

                                                                <div class="form-check py-0">
                                                                    <label class="form-check-label">
                                                                        <input class="form-check-input" type="checkbox"
                                                                            onchange="cloneInput('collapse<?php echo e($currLang->id); ?>', 'collapse<?php echo e($language->id); ?>', event)">
                                                                        <span
                                                                            class="form-check-sign"><?php echo e(__('Clone for')); ?>

                                                                            <strong
                                                                                class="text-capitalize text-secondary"><?php echo e($language->name); ?></strong>
                                                                            <?php echo e(__('language')); ?></span>
                                                                    </label>
                                                                </div>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>

                                <div class="row">
                                    <div class="col-lg-12" id="variation_pricing">
                                        <h4 for=""><?php echo e(__('Additional Features (Optional)')); ?></h4>
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th><?php echo e(__('Label')); ?></th>
                                                    <th><?php echo e(__('Value')); ?></th>
                                                    <th><a href="" class="btn btn-sm btn-success addRow"><i
                                                                class="fas fa-plus-circle"></i></a></th>
                                                </tr>
                                            <tbody id="tbody">
                                                <tr>
                                                    <td>
                                                        <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <div
                                                                class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                <input type="text"
                                                                    name="<?php echo e($language->code); ?>_label[]"
                                                                    class="form-control"
                                                                    placeholder="Label (<?php echo e($language->name); ?>)">
                                                            </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </td>
                                                    <td>
                                                        <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <div
                                                                class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                <input type="text"
                                                                    name="<?php echo e($language->code); ?>_value[]"
                                                                    class="form-control"
                                                                    placeholder="Value (<?php echo e($language->name); ?>)">
                                                            </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </td>
                                                    <td>
                                                        <a href="javascript:void(0)"
                                                            class="btn btn-danger  btn-sm deleteRow">
                                                            <i class="fas fa-minus"></i></a>
                                                    </td>
                                                </tr>
                                            </tbody>
                                            </thead>
                                        </table>
                                    </div>
                                </div>

                                <div id="sliders"></div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="card-footer">
                    <div class="row">
                        <div class="col-12 text-center">
                            <button type="submit" id="PropertySubmit" class="btn btn-success">
                                <?php echo e(__('Save')); ?>

                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php
    $languages = App\Models\Language::get();
    $labels = '';
    $values = '';
    foreach ($languages as $language) {
        $label_name = $language->code . '_label[]';
        $value_name = $language->code . '_value[]';
        if ($language->direction == 1) {
            $direction = 'form-group rtl text-right';
        } else {
            $direction = 'form-group';
        }

        $labels .=
            "<div class='$direction'><input type='text' name='" .
            $label_name .
            "' class='form-control' placeholder='Label ($language->name)'></div>";
        $values .= "<div class='$direction'><input type='text' name='$value_name' class='form-control' placeholder='Value ($language->name)'></div>";
    }
?>

<?php $__env->startSection('script'); ?>
    <script>
        'use strict';
        var labels = "<?php echo $labels; ?>";
        var values = "<?php echo $values; ?>";
        var storeUrl = "<?php echo e(route('admin.property.imagesstore', ['vendor_id' => 0])); ?>";
        var removeUrl = "<?php echo e(route('admin.property.imagermv')); ?>";
        var stateUrl = "<?php echo e(route('admin.property_specification.get_state_cities')); ?>";
        let cityUrl = "<?php echo e(route('admin.property_specification.get_cities')); ?>";
        let agentUrl = "<?php echo e(route('admin.property_management.get_agent')); ?>";
        let galleryImages = 999999;
    </script>

    <script type="text/javascript" src="<?php echo e(asset('assets/js/admin-partial.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('assets/js/admin-dropzone.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('assets/js/property.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\creabiz\paradox\resources\views/backend/property/create.blade.php ENDPATH**/ ?>