

<?php if ($__env->exists('backend.partials.rtl_style')) echo $__env->make('backend.partials.rtl_style', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->startSection('content'); ?>
    <div class="page-header">
        <h4 class="page-title"><?php echo e(__('Feature Properties')); ?></h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="<?php echo e(route('admin.dashboard')); ?>">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#"><?php echo e(__('Feature Properties')); ?></a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#"><?php echo e(__('Pricing')); ?></a>
            </li>
        </ul>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-6">
                            <div class="card-title d-inline-block"><?php echo e(__(' Pricing')); ?></div>
                        </div>
                        <div class="col-6  ">
                            <a href="#" class="btn btn-primary float-right btn-sm" data-toggle="modal"
                                data-target="#createModal"><i class="fas fa-plus"></i>
                                <?php echo e(__('Add Pricing')); ?></a>
                             
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-12">
                            <?php if(count($featuredPricing) == 0): ?>
                                <h3 class="text-center"><?php echo e(__('NO PRICING FOUND YET')); ?></h3>
                            <?php else: ?>
                                <div class="table-responsive">
                                    <table class="table table-striped mt-3" id="basic-datatables">
                                        <thead>
                                            <tr>


                                                <th scope="col"><?php echo e(__('Number of Days')); ?></th>
                                                <th scope="col"><?php echo e(__('Cost')); ?></th>
                                                <th scope="col"><?php echo e(__('Status')); ?></th>
                                                <th scope="col"><?php echo e(__('Actions')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $featuredPricing; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $pricing): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>


                                                    <td> <?php echo e($pricing->number_of_days); ?> </td>
                                                    <td> <?php echo e(symbolPrice($pricing->price)); ?> </td>
                                                    <td>
                                                        <?php if($pricing->status == 1): ?>
                                                            <h2 class="d-inline-block">
                                                                <span
                                                                    class="badge badge-success"><?php echo e(__('Active')); ?></span>
                                                            </h2>
                                                        <?php else: ?>
                                                            <h2 class="d-inline-block">
                                                                <span
                                                                    class="badge badge-danger"><?php echo e(__('Inactive')); ?></span>
                                                            </h2>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <div class="dropdown">
                                                            <button class="btn btn-secondary dropdown-toggle btn-sm"
                                                                type="button" id="dropdownMenuButton"
                                                                data-toggle="dropdown" aria-haspopup="true"
                                                                aria-expanded="false">
                                                                <?php echo e(__('Select')); ?>

                                                            </button>

                                                            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">

                                                                <a class="dropdown-item"
                                                                    href="<?php echo e(route('admin.featured_pricing.edit', $pricing->id) . '?language=' . request()->input('language')); ?>">
                                                                    <span class="btn-label">
                                                                        <i class="fas fa-edit"></i> <?php echo e(__('Edit')); ?>

                                                                    </span>
                                                                </a>
                                                                <form class="deleteForm d-inline-block dropdown-item"
                                                                    action="<?php echo e(route('admin.featured_pricing.delete')); ?>"
                                                                    method="post">
                                                                    <?php echo csrf_field(); ?>
                                                                    <input type="hidden" name="pricing_id"
                                                                        value="<?php echo e($pricing->id); ?>">
                                                                    <button type="submit" class="btn p-0 deleteBtn">
                                                                        <span class="btn-label">
                                                                            <i class="fas fa-trash-alt"></i>
                                                                            <?php echo e(__('Delete')); ?>

                                                                        </span>
                                                                    </button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Create Blog Modal -->
    <div class="modal fade" id="createModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle"><?php echo e(__('Add Pricing')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">

                    <form id="ajaxForm" enctype="multipart/form-data" class="modal-form"
                        action="<?php echo e(route('admin.featured_pricing.store')); ?>" method="POST">
                        <?php echo csrf_field(); ?>



                        <div class="form-group">
                            <label class="form-label"><?php echo e(__('Number Of Days')); ?>

                                *</label>
                            <input type="text" name="number_of_days" class="form-control"
                                placeholder="<?php echo e(__('Enter how many properties does the vendor make featured')); ?>">
                            <p id="err_number_of_days" class="mb-0 text-danger em"></p>
                        </div>

                        <div class="form-group">
                            <label for="price"><?php echo e(__('Price')); ?> (<?php echo e($settings->base_currency_text); ?>)*</label>
                            <input id="price" type="number" class="form-control" name="price"
                                placeholder="<?php echo e(__('Enter featured price')); ?>" value="">
                            <p class="text-warning mb-0">
                                <small><?php echo e(__('If price is 0 , than it will appear as free')); ?></small>
                            </p>
                            <p id="err_price" class="mb-0 text-danger em"></p>
                        </div>



                        <div class="form-group">
                            <label for="status"><?php echo e(__('Status')); ?>*</label>
                            <select id="status" class="form-control ltr" name="status">
                                <option value="" selected disabled><?php echo e(__('Select a status')); ?></option>
                                <option value="1"><?php echo e(__('Active')); ?></option>
                                <option value="0"><?php echo e(__('Inactive')); ?></option>
                            </select>
                            <p id="err_status" class="mb-0 text-danger em"></p>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                    <button id="submitBtn" type="button" class="btn btn-primary"><?php echo e(__('Submit')); ?></button>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script src="<?php echo e(asset('assets/js/packages.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\creabiz\paradox\resources\views/backend/featured-properties/index.blade.php ENDPATH**/ ?>