<?php
    $version = $basicInfo->theme_version;
?>


<?php $__env->startSection('pageHeading'); ?>
    <?php echo e($project->title); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('metaKeywords'); ?>
    <?php if(!empty($project)): ?>
        <?php echo e($project->meta_keyword); ?>

    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('metaDescription'); ?>
    <?php if(!empty($project)): ?>
        <?php echo e($project->meta_description); ?>

    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('og:tag'); ?>
    <meta property="og:title" content="<?php echo e($project->title); ?>">
    <meta property="og:image" content="<?php echo e(asset('assets/img/project/featured/' . $project->featured_image)); ?>">
    <meta property="og:url" content="<?php echo e(route('frontend.projects.details', $project->slug)); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Page Title Start-->
    <div class="page-title-area header-next">
        <!-- Background Image -->
        <img class="lazyload blur-up bg-img" src="<?php echo e(asset('assets/img/' . $bgImg->breadcrumb)); ?>">
        <div class="container">
            <div class="content text-center">
                <div class="row justify-content-center">
                    <div class="col-lg-12">
                        <h1 class="color-white"><?php echo e($project->title); ?></h1>
                        <p class="font-lg color-white mx-auto"> <span class="product-location icon-start"><i
                                    class="fal fa-map-marker-alt"></i><?php echo e($project->address); ?></span>
                        </p>
                        <p class="font-lg color-white mx-auto"> <span class="product-location icon-start"><i
                                    class="fal fa-user"></i>
                                <?php if($project->vendor_id == 0): ?>
                                    <?php echo e($username); ?>

                                <?php else: ?>
                                    <?php echo e($project->vendor->username); ?>

                                <?php endif; ?>
                            </span>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Page Title End-->

    <div class="divider">
        <div class="icon"><a href="#tapDown"><i class="fal fa-long-arrow-down"></i></a></div>
        <span class="line"></span>
    </div>

    <div class="projects-details-area pt-100 pb-70" id="tapDown">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="project-desc mb-40" data-aos="fade-up">
                        <h3 class="mb-20"><?php echo e(__('Project Overview')); ?></h3>
                        <p class="summernote-content">
                            <?php echo $project->description; ?>

                        </p>

                    </div>
                    <?php if(!empty(showAd(3))): ?>
                        <div class="text-center mb-3 mt-3">
                            <?php echo showAd(3); ?>

                        </div>
                    <?php endif; ?>
                    <div class="">
                        <p>

                            <a class="btn btn-primary btn-md" href="#" data-bs-toggle="modal"
                                data-bs-target="#socialMediaModal">
                                <i class="far fa-share-alt"></i>
                                <span><?php echo e(__('Share')); ?> </span>
                            </a>

                        </p>
                    </div>
                    <div class="pb-20"></div>
                    <?php if(count($project->specifications) > 0): ?>
                        <div class="row" class="mb-20">
                            <div class="col-12">
                                <h3 class="mb-20"><?php echo e(__('Features')); ?></h3>
                            </div>

                            <?php $__currentLoopData = $project->specifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $specification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $project_specification_content = App\Models\Project\SpacificationContent::where([
                                        ['project_spacification_id', $specification->id],
                                        ['language_id', $language->id],
                                    ])->first();
                                ?>
                                <div class="col-lg-3 col-sm-6 col-md-4 mb-20">
                                    <strong class="mb-1 text-dark"><?php echo e($project_specification_content?->label); ?></strong>
                                    <br>
                                    <span><?php echo e($project_specification_content?->value); ?></span>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="pb-20"></div>
                    <?php endif; ?>

                    <div class="pb-20"></div>

                    <div class="project-location mb-40" data-aos="fade-up">
                        <h3 class="mb-20"> <?php echo e(__('Location')); ?></h3>
                        <div class="lazy-container radius-lg ratio ratio-21-8 border">
                            <iframe class="lazyload"
                                src="https://maps.google.com/maps?q=<?php echo e($project->latitude); ?>,<?php echo e($project->longitude); ?>&hl=<?php echo e($currentLanguageInfo->code); ?>;z=15&amp;output=embed"></iframe>
                        </div>
                    </div>

                    <div class="pb-20"></div>
                    <!-- Space -->

                    

                    <div class="pb-20"></div><!-- Space -->
                    <?php if(count($project->projectTypeContents) > 0): ?>
                        <div class="project-type mb-10" data-aos="fade-up">
                            <h3 class="mb-20"><?php echo e(__('Project Types')); ?></h3>
                            <div class="row">
                                <?php $__currentLoopData = $project->projectTypeContents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $typeContent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-lg-4 col-md-6">
                                        <div class="card border mb-30">
                                            <div class="card-content">
                                                <ul class="m-0 p-0">
                                                    <li class="d-flex align-items-center">
                                                        <span class="font-lg color-dark"><?php echo e(__('Area')); ?></span>
                                                        <span class="icon-start"> <i
                                                                class="fal fa-vector-square"></i><?php echo e($typeContent?->min_area); ?>

                                                            <?php if(!empty($typeContent->max_area)): ?>
                                                                <?php echo e(' - ' . $typeContent->max_area); ?>

                                                            <?php endif; ?>
                                                            <?php echo e(__('Sqft')); ?>

                                                        </span>
                                                    </li>
                                                    <li class="d-flex align-items-center">
                                                        <span class="font-lg color-dark"><?php echo e(__('Price')); ?></span>
                                                        <span class="icon-start"><i
                                                                class="ico-save-money"></i><?php echo e(symbolPrice($typeContent?->min_price)); ?>

                                                            <?php if(!empty($typeContent->max_price)): ?>
                                                                <?php echo e(' - ' . symbolPrice($typeContent->max_price)); ?>

                                                            <?php endif; ?>
                                                        </span>
                                                    </li>
                                                    <li class="d-flex align-items-center">
                                                        <span class="font-lg color-dark"><?php echo e(__('Unit')); ?></span>
                                                        <span class="icon-start"><i
                                                                class="ico-home"></i><?php echo e($typeContent?->unit); ?></span>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if(!empty(showAd(3))): ?>
                        <div class="text-center mb-3 mt-3">
                            <?php echo showAd(3); ?>

                        </div>
                    <?php endif; ?>
                    <div class="pb-20"></div><!-- Space -->

                    <div class="project-gallery">
                        <h3 class="mb-20"> <?php echo e(__('Project Gallery Images')); ?> </h3>
                        <div class="row masonry-gallery grid gallery-popup">
                            <div class="col-lg-4 col-md-6 grid-sizer"></div>
                            <?php $__currentLoopData = $galleryImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gallery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-lg-4 col-md-6 grid-item mb-30">
                                    <div class="card radius-md">
                                        <a href="<?php echo e(asset('assets/img/project/gallery-images/' . $gallery->image)); ?>"
                                            class="card-img">
                                            <img src="<?php echo e(asset('assets/img/project/gallery-images/' . $gallery->image)); ?>">
                                        </a>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="socialMediaModal" tabindex="-1" role="dialog" aria-labelledby="socialMediaModalTitle"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle"> <?php echo e(__('Share On')); ?> </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="actions d-flex justify-content-around">
                        <div class="action-btn">
                            <a class="facebook btn"
                                href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(url()->current()); ?>&src=sdkpreparse"><i
                                    class="fab fa-facebook-f"></i></a>
                            <br>
                            <span> <?php echo e(__('Facebook')); ?> </span>
                        </div>
                        <div class="action-btn">
                            <a href="http://www.linkedin.com/shareArticle?mini=true&amp;url=<?php echo e(urlencode(url()->current())); ?>"
                                class="linkedin btn"><i class="fab fa-linkedin-in"></i></a>
                            <br>
                            <span> <?php echo e(__('Linkedin')); ?> </span>
                        </div>
                        <div class="action-btn">
                            <a class="twitter btn" href="https://twitter.com/intent/tweet?text=<?php echo e(url()->current()); ?>"><i
                                    class="fab fa-twitter"></i></a>
                            <br>
                            <span> <?php echo e(__('Twitter')); ?> </span>
                        </div>
                        <div class="action-btn">
                            <a class="whatsapp btn" href="whatsapp://send?text=<?php echo e(url()->current()); ?>"><i
                                    class="fab fa-whatsapp"></i></a>
                            <br>
                            <span> <?php echo e(__('Whatsapp')); ?> </span>
                        </div>
                        <div class="action-btn">
                            <a class="sms btn" href="sms:?body=<?php echo e(url()->current()); ?>" class="sms"><i
                                    class="fas fa-sms"></i></a>
                            <br>
                            <span> <?php echo e(__('SMS')); ?> </span>
                        </div>
                        <div class="action-btn">
                            <a class="mail btn"
                                href="mailto:?subject=Digital Card&body=Check out this digital card <?php echo e(url()->current()); ?>."><i
                                    class="fas fa-at"></i></a>
                            <br>
                            <span> <?php echo e(__('Mail')); ?> </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("frontend.layouts.layout-v$version", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\creabiz\paradox\resources\views/frontend/project/details.blade.php ENDPATH**/ ?>