<?php
    $version = $basicInfo->theme_version;
?>


<?php $__env->startSection('pageHeading'); ?>
    <?php echo e(__('Home')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('metaKeywords'); ?>
    <?php if(!empty($seoInfo)): ?>
        <?php echo e($seoInfo->meta_keyword_home); ?>

    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('metaDescription'); ?>
    <?php if(!empty($seoInfo)): ?>
        <?php echo e($seoInfo->meta_description_home); ?>

    <?php endif; ?>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>

    <section class="home-banner home-banner-2">
        <div class="container">
            <div class="swiper home-slider" id="home-slider-1">
                <div class="swiper-wrapper">
                    <?php $__currentLoopData = $sliderInfos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="swiper-slide">
                            <div class="content">
                                <span class="subtitle color-white"><?php echo e($slider->title); ?></span>
                                <h1 class="title color-white mb-0"><?php echo e($slider->text); ?></h1>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>
            </div>
            <div class="banner-filter-form mt-40" data-aos="fade-up">
                <div class="row justify-content-center">
                    <div class="col-xxl-10">
                        <div class="tabs-navigation">
                            <ul class="nav nav-tabs">
                                <li class="nav-item">
                                    <button class="nav-link btn-md rounded-pill active" data-bs-toggle="tab"
                                        data-bs-target="#rent" type="button"><?php echo e(__('Rent')); ?></button>
                                </li>
                                <li class="nav-item">
                                    <button class="nav-link btn-md rounded-pill" data-bs-toggle="tab" data-bs-target="#sale"
                                        type="button"><?php echo e(__('Sale')); ?></button>
                                </li>

                            </ul>
                        </div>
                        <div class="tab-content form-wrapper radius-md">
                            <input type="hidden" id="currency_symbol" value="<?php echo e($basicInfo->base_currency_symbol); ?>">
                            <input type="hidden" name="min" value="<?php echo e($min); ?>" id="min">
                            <input type="hidden" name="max" value="<?php echo e($max); ?>" id="max">

                            <input class="form-control" type="hidden" value="<?php echo e($min); ?>" id="o_min">
                            <input class="form-control" type="hidden" value="<?php echo e($max); ?>" id="o_max">
                            <div class="tab-pane fade show active" id="rent">
                                <form action="<?php echo e(route('frontend.properties')); ?>" method="get">
                                    <input type="hidden" name="purposre" value="rent">
                                    <input type="hidden" name="min" value="<?php echo e($min); ?>" id="min1">
                                    <input type="hidden" name="max" value="<?php echo e($max); ?>" id="max1">
                                    <div class="grid">
                                        <div class="grid-item">
                                            <div class="form-group">
                                                <label for="search1"><?php echo e(__('Location')); ?></label>
                                                <input type="text" id="search1" name="location" class="form-control"
                                                    placeholder="<?php echo e(__('Location')); ?>">
                                            </div>
                                        </div>
                                        <div class="grid-item">
                                            <div class="form-group">
                                                <label for="type" class="icon-end"><?php echo e(__('Property Type')); ?></label>
                                                <select aria-label="#" name="type" class="form-control select2 type"
                                                    id="type">
                                                    <option selected disabled value=""><?php echo e(__('Select Property')); ?>

                                                    </option>
                                                    <option value="all"><?php echo e(__('All')); ?></option>
                                                    <option value="residential"><?php echo e(__('Residential')); ?></option>
                                                    <option value="commercial"><?php echo e(__('Commercial')); ?></option>

                                                </select>
                                            </div>
                                        </div>
                                        <div class="grid-item">
                                            <div class="form-group">
                                                <label for="category" class="icon-end"><?php echo e(__('Categories')); ?></label>
                                                <select aria-label="#" class="form-control select2 bringCategory"
                                                    id="category" name="category">
                                                    <option selected disabled value=""><?php echo e(__('Select Category')); ?>

                                                    </option>
                                                    <option value="all"><?php echo e(__('All')); ?></option>
                                                    <?php $__currentLoopData = $all_proeprty_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e(@$category->categoryContent->slug); ?>">
                                                            <?php echo e(@$category->categoryContent->name); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </select>
                                            </div>
                                        </div>

                                        <div class="grid-item city">
                                            <div class="form-group">
                                                <label for="city" class="icon-end"><?php echo e(__('City')); ?></label>
                                                <select aria-label="#" name="city" class="form-control select2 city_id"
                                                    id="city">
                                                    <option selected disabled value=""><?php echo e(__('Select City')); ?>

                                                    </option>
                                                    <option value="all"><?php echo e(__('All')); ?></option>
                                                    <?php $__currentLoopData = $all_cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option data-id="<?php echo e($city->id); ?>"
                                                            value="<?php echo e($city->cityContent?->name); ?>">
                                                            <?php echo e($city->cityContent?->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </select>
                                            </div>
                                        </div>
                                        <div class="grid-item">
                                            <label class="price-value"><?php echo e(__('Price')); ?>: <br>
                                                <span data-range-value="filterPriceSliderValue"><?php echo e(symbolPrice($min)); ?>

                                                    -
                                                    <?php echo e(symbolPrice($max)); ?></span>
                                            </label>
                                            <div data-range-slider="filterPriceSlider"></div>
                                        </div>
                                        <div class="grid-item">
                                            <button type="submit"
                                                class="btn btn-lg btn-primary bg-primary icon-start w-100">
                                                <?php echo e(__('Search')); ?>

                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                            <div class="tab-pane fade" id="sale">
                                <form action="<?php echo e(route('frontend.properties')); ?>" method="get">
                                    <input type="hidden" name="purposre" value="sale">
                                    <input type="hidden" name="min" value="<?php echo e($min); ?>" id="min2">
                                    <input type="hidden" name="max" value="<?php echo e($max); ?>" id="max2">
                                    <div class="grid">
                                        <div class="grid-item">
                                            <div class="form-group">
                                                <label for="search1"><?php echo e(__('Location')); ?></label>
                                                <input type="text" id="search1" name="location"
                                                    class="form-control" placeholder="<?php echo e(__('Location')); ?>">
                                            </div>
                                        </div>
                                        <div class="grid-item">
                                            <div class="form-group">
                                                <label for="type1" class="icon-end"><?php echo e(__('Property Type')); ?></label>
                                                <select aria-label="#" name="type" class="form-control select2 type"
                                                    id="type1">
                                                    <option selected disabled value=""><?php echo e(__('Select Property')); ?>

                                                    </option>
                                                    <option value="all"><?php echo e(__('All')); ?></option>
                                                    <option value="residential"><?php echo e(__('Residential')); ?></option>
                                                    <option value="commercial"><?php echo e(__('Commercial')); ?></option>

                                                </select>
                                            </div>
                                        </div>
                                        <div class="grid-item">
                                            <div class="form-group">
                                                <label for="category1" class="icon-end"><?php echo e(__('Categories')); ?></label>
                                                <select aria-label="#" class="form-control select2 bringCategory"
                                                    id="category1" name="category">
                                                    <option selected disabled value=""><?php echo e(__('Select Category')); ?>

                                                    </option>
                                                    <option value="all"><?php echo e(__('All')); ?></option>
                                                    <?php $__currentLoopData = $all_proeprty_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e(@$category->categoryContent->slug); ?>">
                                                            <?php echo e(@$category->categoryContent->name); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="grid-item city">
                                            <div class="form-group">
                                                <label for="city1" class="icon-end"><?php echo e(__('City')); ?></label>
                                                <select aria-label="#" name="city"
                                                    class="form-control select2 city_id" id="city1">
                                                    <option selected disabled value=""><?php echo e(__('Select City')); ?>

                                                    </option>
                                                    <option value="all"><?php echo e(__('All')); ?></option>

                                                    <?php $__currentLoopData = $all_cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option data-id="<?php echo e($city->id); ?>"
                                                            value="<?php echo e(@$city->cityContent->name); ?>">
                                                            <?php echo e(@$city->cityContent->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </select>
                                            </div>
                                        </div>
                                        <div class="grid-item">
                                            <label class="price-value"><?php echo e(__('Price')); ?>: <br>
                                                <span data-range-value="filterPriceSlider2Value"><?php echo e(symbolPrice($min)); ?>

                                                    -
                                                    <?php echo e(symbolPrice($max)); ?></span>
                                            </label>
                                            <div data-range-slider="filterPriceSlider2"></div>
                                        </div>
                                        <div class="grid-item">
                                            <button type="submit"
                                                class="btn btn-lg btn-primary bg-primary icon-start w-100">
                                                <?php echo e(__('Search')); ?>

                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="swiper home-img-slider" id="home-img-slider-1">
            <div class="swiper-wrapper">
                <?php $__currentLoopData = $sliderInfos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="swiper-slide">
                        <img class="lazyload bg-img"
                            src=" <?php echo e(asset('assets/img/hero/sliders/' . $slider->background_image)); ?>">
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


            </div>
        </div>
    </section>
    <?php if($secInfo->brand_section_status == 1): ?>
        <div class="sponsor ptb-100" data-aos="fade-up">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="swiper sponsor-slider">
                            <div class="swiper-wrapper">
                                <?php $__empty_1 = true; $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <div class="swiper-slide">
                                        <div class="item-single d-flex justify-content-center">
                                            <div class="sponsor-img">
                                                <a href="<?php echo e($brand->url); ?>" target="_blank">
                                                    <img src=" <?php echo e(asset('assets/img/brands/' . $brand->image)); ?> ">
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <div class="p-3 text-center mb-30 w-100">
                                        <h3 class="mb-0"><?php echo e(__('No Brands Found')); ?></h3>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <!-- Slider pagination -->
                            <div class="swiper-pagination position-static mt-30" id="sponsor-slider-pagination"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    
    <?php if($secInfo->about_section_status == 1): ?>
        <section class="about-area pt-100 pb-70 mt-30">
            <div class="container">
                <div class="row gx-xl-5">
                    <div class="col-lg-6">
                        <div class="img-content mb-30" data-aos="fade-right">
                            <div class="image">
                                <img class="lazyload blur-up"
                                    data-src="<?php echo e(asset('assets/img/about_section/' . $aboutImg->about_section_image1)); ?>">

                                <img class="lazyload blur-up"
                                    data-src="<?php echo e(asset('assets/img/about_section/' . $aboutImg->about_section_image2)); ?>">
                            </div>
                            <div class="absolute-text bg-secondary">
                                <div class="center-text">
                                    <span class="h2 color-primary">15+</span>
                                    <span><?php echo e(__('Years')); ?></span>
                                </div>
                                <div id="curveText">of Experience across UAE</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="content  mb-30" data-aos="fade-left">
                            <div class="content-title">
                                <span class="subtitle"><span
                                        class="line"></span><?php echo e($aboutInfo->title); ?></span>
                                <h2><?php echo e($aboutInfo?->sub_title); ?></h2>
                            </div>
                            <div class="text summernote-content"><?php echo $aboutInfo?->description; ?></div>

                            <div class="d-flex align-items-center flex-wrap gap-15">


                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>


    <?php if($secInfo->featured_properties_section_status == 1): ?>
        <section class="featured-product pt-100 pb-70">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="section-title title-inline mb-40" data-aos="fade-up">
                            <h2 class="title"><?php echo e($featuredSecInfo->title); ?></h2>
                            <!-- Slider navigation buttons -->
                            <div class="slider-navigation">
                                <button type="button" title="Slide prev"
                                    class="slider-btn product-slider-btn-prev rounded-pill">
                                    <i class="fal fa-angle-left"></i>
                                </button>
                                <button type="button" title="Slide next"
                                    class="slider-btn product-slider-btn-next rounded-pill">
                                    <i class="fal fa-angle-right"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="col-12" data-aos="fade-up">
                        <div class="swiper product-slider">
                            <div class="swiper-wrapper">
                                <?php $__empty_1 = true; $__currentLoopData = $featured_properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    
                                    <div class="swiper-slide">
                                        <?php if (isset($component)) { $__componentOriginal639634bf4019fd173d700efbbafd2b3557577062 = $component; } ?>
<?php $component = App\View\Components\Property::resolve(['property' => $property] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('property'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Property::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal639634bf4019fd173d700efbbafd2b3557577062)): ?>
<?php $component = $__componentOriginal639634bf4019fd173d700efbbafd2b3557577062; ?>
<?php unset($__componentOriginal639634bf4019fd173d700efbbafd2b3557577062); ?>
<?php endif; ?>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <div class=" p-3 text-center mb-30 w-100">
                                        <h3 class="mb-0"> <?php echo e(__('No Featured Property Found')); ?></h3>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>

    <?php if($secInfo->call_to_action_section_status == 1): ?>
        <section class="video-banner with-radius pt-100 pb-70">
            <!-- Background Image -->
            <div class="bg-overlay">
                <img class="lazyload bg-img" src=" <?php echo e(asset('assets/img/' . $callToActionSectionImage)); ?>">
            </div>
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-5">
                        <div class="content mb-30" data-aos="fade-up">
                            <span class="subtitle text-white"><?php echo e($callToActionSecInfo->title); ?></span>
                            <h2 class="title text-white mb-10"><?php echo e($callToActionSecInfo?->subtitle); ?></h2>
                            <p class="text-white m-0 w-75 w-sm-100"><?php echo e($callToActionSecInfo?->text); ?></p>
                        </div>
                    </div>
                    <div class="col-lg-7">
                        <?php if(!empty($callToActionSecInfo?->video_url)): ?>
                            <div class="d-flex align-items-center justify-content-center h-100 mb-30" data-aos="fade-up">
                                <a href="<?php echo e($callToActionSecInfo->video_url); ?>" class="video-btn youtube-popup">
                                    <i class="fas fa-play"></i>
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>
    <style>
        .calc-section {
            padding: 30px 0;
            background: #f8f9fa;
        }

        .calc-card {
            background: white;
            border-radius: 8px;
            padding: 0;
            margin-bottom: 20px;
        }

        .calc-header {
            background: #bda588;
            color: white;
            padding: 15px;
            text-align: center;
        }

        .calc-body {
            padding: 20px;
        }

        .result-box {
            background: #e9ecef;
            padding: 15px;
            border-radius: 5px;
            text-align: center;
            margin-top: 20px;
        }

        .calc-image {
            height: 100%;
            border-radius: 8px;
            overflow: hidden;
        }

        .calc-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        @media (max-width: 768px) {
            .calc-image {
                height: 200px;
                margin-top: 20px;
            }
        }
    </style>
    <section class="calc-section">
      <div class="container">
          <div class="row">
              <div class="col-lg-7">
                  <div class="calc-card">
                      <div class="calc-header">
                          <h4 class="mb-0"><i class="fas fa-calculator me-2"></i>Property Calculator</h4>
                      </div>
                      <div class="calc-body">
                          <form id="calculatorForm">
                              <div class="row mb-3">
                                  <div class="col-md-6">
                                      <label class="form-label">Property Price (AED)</label>
                                      <input type="number" id="total_amount" class="form-control" placeholder="Enter amount">
                                  </div>
                                  <div class="col-md-6">
                                      <label class="form-label">Down Payment (AED)</label>
                                      <input type="number" id="down_payment" class="form-control" placeholder="Enter amount">
                                  </div>
                              </div>

                              <div class="row mb-3">
                                  <div class="col-md-6">
                                      <label class="form-label">Interest Rate (%)</label>
                                      <input type="number" id="interest_rate" class="form-control" placeholder="Enter rate" step="0.1">
                                  </div>
                                  <div class="col-md-6">
                                      <label class="form-label">Loan Term (years)</label>
                                      <input type="number" id="loan_term" class="form-control" placeholder="Enter years">
                                  </div>
                              </div>

                              <div class="row mb-3">
                                  <div class="col-md-6">
                                      <label class="form-label">Service Charges (AED/year)</label>
                                      <input type="number" id="service_charges" class="form-control" placeholder="Enter amount">
                                  </div>
                                  <div class="col-md-6">
                                      <label class="form-label">Insurance (AED/year)</label>
                                      <input type="number" id="insurance" class="form-control" placeholder="Enter amount">
                                  </div>
                              </div>

                              <div class="text-center mt-4">
                                  <button type="button" id="calculateBtn" class="btn btn-lg btn-primary bg-primary icon-start">
                                      Calculate Payment
                                  </button>
                                  <button type="reset" class="btn btn-lg btn-outline icon-start">
                                      Reset
                                  </button>
                              </div>
                          </form>

                          <div class="result-box">
                              <h5>Monthly Payment:</h5>
                              <div class="h4 text-primary" id="result">AED 0.00</div>
                              <small class="text-muted">Mortgage + Service Charges + Insurance</small>
                          </div>
                      </div>
                  </div>
              </div>

              <div class="col-lg-5">
                  <div class="calc-image">
                      <img src="https://images.unsplash.com/photo-1512453979798-5ea266f8880c?ixlib=rb-1.2.1&auto=format&fit=crop&w=800&q=80" alt="Dubai Property">
                  </div>
              </div>
          </div>
      </div>
    </section>

  <!-- Bootstrap JS with Popper -->
  
  <script>
      document.addEventListener('DOMContentLoaded', function() {
          const calculateBtn = document.getElementById('calculateBtn');

          calculateBtn.addEventListener('click', function() {
              // Get input values
              const totalAmount = parseFloat(document.getElementById('total_amount').value) || 0;
              const downPayment = parseFloat(document.getElementById('down_payment').value) || 0;
              const interestRate = parseFloat(document.getElementById('interest_rate').value) || 0;
              const loanTerm = parseFloat(document.getElementById('loan_term').value) || 1;
              const serviceCharges = parseFloat(document.getElementById('service_charges').value) || 0;
              const insurance = parseFloat(document.getElementById('insurance').value) || 0;

              // Calculate loan amount
              const loanAmount = totalAmount - downPayment;

              // Convert years to months
              const months = loanTerm * 12;

              // Calculate monthly interest rate
              const monthlyInterest = (interestRate / 100) / 12;

              // Calculate monthly payment
              let monthlyPayment = 0;

              if (interestRate === 0) {
                  monthlyPayment = loanAmount / months;
              } else {
                  monthlyPayment = (loanAmount * monthlyInterest) / (1 - Math.pow(1 + monthlyInterest, -months));
              }

              // Add service charges and insurance
              monthlyPayment += (serviceCharges / 12) + (insurance / 12);

              // Format and display result
              const resultElement = document.getElementById('result');
              resultElement.textContent = `AED ${monthlyPayment.toLocaleString('en-US', {minimumFractionDigits: 2, maximumFractionDigits: 2})}`;
          });
      });
  </script>
    <?php if($secInfo->property_section_status == 1): ?>
        <section class="popular-product pt-100 pb-70">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="section-title title-inline mb-40" data-aos="fade-up">
                            <h2 class="title"><?php echo e($propertySecInfo->title); ?></h2>
                            <div class="tabs-navigation">
                                <ul class="nav nav-tabs">
                                    <li class="nav-item">
                                        <button class="nav-link active btn-md rounded-pill" data-bs-toggle="tab"
                                            data-bs-target="#forAll" type="button"><?php echo e(__('All Properties')); ?></button>
                                    </li>
                                    <li class="nav-item">
                                        <button class="nav-link btn-md rounded-pill" data-bs-toggle="tab"
                                            data-bs-target="#offPlan" type="button">Off Plan</button>
                                    </li>
                                    <li class="nav-item">
                                        <button class="nav-link btn-md rounded-pill" data-bs-toggle="tab"
                                            data-bs-target="#forRent" type="button"><?php echo e(__('For Rent')); ?></button>
                                    </li>
                                    <li class="nav-item">
                                        <button class="nav-link btn-md rounded-pill" data-bs-toggle="tab"
                                            data-bs-target="#forSell" type="button"><?php echo e(__('For Sale')); ?></button>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="tab-content" data-aos="fade-up">
                            <div class="tab-pane fade show active" id="forAll">
                                <div class="row">
                                    <?php $__empty_1 = true; $__currentLoopData = $properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                     
                                        <?php if (isset($component)) { $__componentOriginal639634bf4019fd173d700efbbafd2b3557577062 = $component; } ?>
<?php $component = App\View\Components\Property::resolve(['property' => $property] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('property'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Property::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'col-xxl-3 col-lg-4 col-sm-6']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal639634bf4019fd173d700efbbafd2b3557577062)): ?>
<?php $component = $__componentOriginal639634bf4019fd173d700efbbafd2b3557577062; ?>
<?php unset($__componentOriginal639634bf4019fd173d700efbbafd2b3557577062); ?>
<?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <div class="p-3 text-center mb-30">
                                            <h3 class="mb-0"> <?php echo e(__('No Properties Found')); ?></h3>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="forRent">
                                <div class="row">
                                    <?php $__empty_1 = true; $__currentLoopData = $properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <?php if($property->purpose == 'rent'): ?>
                                          
                                            <?php if (isset($component)) { $__componentOriginal639634bf4019fd173d700efbbafd2b3557577062 = $component; } ?>
<?php $component = App\View\Components\Property::resolve(['property' => $property] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('property'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Property::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'col-xxl-3 col-lg-4 col-sm-6']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal639634bf4019fd173d700efbbafd2b3557577062)): ?>
<?php $component = $__componentOriginal639634bf4019fd173d700efbbafd2b3557577062; ?>
<?php unset($__componentOriginal639634bf4019fd173d700efbbafd2b3557577062); ?>
<?php endif; ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <div class=" p-3 text-center mb-30">
                                            <h3 class="mb-0"> <?php echo e(__('No Properties Found')); ?></h3>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="forSell">
                                <div class="row">
                                    <?php $__empty_1 = true; $__currentLoopData = $properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <?php if($property->purpose == 'sale'): ?>
                                          
                                            <?php if (isset($component)) { $__componentOriginal639634bf4019fd173d700efbbafd2b3557577062 = $component; } ?>
<?php $component = App\View\Components\Property::resolve(['property' => $property] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('property'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Property::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'col-xxl-3 col-lg-4 col-sm-6']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal639634bf4019fd173d700efbbafd2b3557577062)): ?>
<?php $component = $__componentOriginal639634bf4019fd173d700efbbafd2b3557577062; ?>
<?php unset($__componentOriginal639634bf4019fd173d700efbbafd2b3557577062); ?>
<?php endif; ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <div class=" p-3 text-center mb-30">
                                            <h3 class="mb-0"> <?php echo e(__('No Properties Found')); ?></h3>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="offPlan">
                                <div class="row">
                                    <?php $__currentLoopData = $offplan['response']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                      <div class="col-xxl-3 col-lg-4 col-sm-6">
                                          <div class="product-default radius-md mb-30 aos-init aos-animate" data-aos="fade-up" data-aos-delay="100">
                                              <figure class="product-img">
                                                  <a href="<?php echo e(route('offplanobject', $property['project_id'])); ?>" class="lazy-container ratio ratio-1-1">
                                                    <img class="lazyload" src="<?php echo e($property['Avatar']); ?>"
                                                        data-src="<?php echo e($property['Avatar']); ?>">
                                                  </a>
                                              </figure>
                                              <div class="product-details">
                                                  <div class="d-flex align-items-center justify-content-between mb-10">
                                                      <div class="author  ">
                                                          <a class="color-medium" href="#" target="_self">
                                                            <img class="blur-up ls-is-cached lazyloaded"
                                                                  data-src="<?php echo e($property['Organisation']['organizationLogo']); ?>"
                                                                  src="<?php echo e($property['Organisation']['organizationLogo']); ?>">
                                                              <span><?php echo e(__('By')); ?> <?php echo e($property['Organisation']['organizationName']); ?></span>
                                                          </a>
                                                      </div>

                                                      <span class="product-category text-sm"></span>

                                                  </div>
                                                  <h3 class="product-title">
                                                      <a
                                                          href="<?php echo e(route('offplanobject', $property['project_id'])); ?>"><?php echo e($property['LongName']); ?></a>
                                                  </h3>

                                                  <span class="product-location icon-start"> <i class="fal fa-map-marker-alt"></i>
                                                      <?php echo e($property['Location']['address']); ?>

                                                  </span>
                                                  <div class="product-price">
                                                      <span class="new-price"><?php echo e(__('Price:')); ?> Starting <?php echo e(symbolPrice($property['LayoutPriceMin'])); ?></span>
                                                  </div>
                                                  <ul class="product-info p-0 list-unstyled d-flex align-items-center">
                                                      <li class="icon-start" data-tooltip="tooltip" data-bs-placement="top" title="<?php echo e(__('Area')); ?>">
                                                          <i class="fal fa-vector-square"></i>
                                                          <span><?php echo e($property['Layouts'][0]['layoutAreaTotal'] ?? 0); ?> <?php echo e(__('Sqft')); ?></span>
                                                      </li>
                                                      <?php
                                                        $buildingTypeIcon = '';
                                                        if($property['Type']['name'] == 'Apartment' || $property['Type']['name'] == 'Penthouse'){
                                                          $buildingTypeIcon = 'far fa-building';
                                                        }else{
                                                          $buildingTypeIcon = 'fas fa-home';
                                                        }
                                                      ?>
                                                        <li class="icon-start" data-tooltip="tooltip" data-bs-placement="top" title="<?php echo e('Property Type'); ?>">
                                                            <i class="<?php echo e($buildingTypeIcon); ?>"></i>
                                                            <span><?php echo e($property['Type']['name']); ?></span>
                                                        </li>
                                                  </ul>
                                              </div>
                                              <span class="label"><?php echo e($property['Layouts'][0]['OfferingType']['name'] ?? ''); ?></span>
                                          </div>
                                      </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>
    <?php if($secInfo->cities_section_status == 1): ?>
      <section class="gallery-area pt-100 pb-70">
          <img class="lazyload bg-img" src="<?php echo e(asset('assets/front/images/245re4e1r53.png')); ?>">
          <div class="container">
              <div class="row">
                  <div class="col-12">
                      <div class="section-title title-inline mb-40" data-aos="fade-up">
                          <div>
                              <span class="subtitle"><span class="line"></span>
                                  <?php echo e($citySecInfo->title); ?></span>
                              <h2 class="title"><?php echo e($citySecInfo?->subtitle); ?></h2>
                          </div>
                      </div>
                  </div>
<div class="col-12">
    <div class="row" data-aos="fade-up">

        <?php $__empty_1 = true; $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="col-lg-4 col-sm-6">
                <div class="card radius-md mb-30 product-default">

                    
                        <div class="card-img">
                            <div class="lazy-container ratio ratio-16-11">
                                <img class="lazyload blur-up"
                                    data-src="<?php echo e(asset('assets/img/project/featured/' . $project->featured_image)); ?>">
                            </div>

                            <span class="label">
                                <?php if($project->status == 0): ?>
                                    <?php echo e(__('Under Construction')); ?>

                                <?php elseif($project->status == 1): ?>
                                    <?php echo e(__('Complete')); ?>

                                <?php endif; ?>
                            </span>
                        </div>

                        <div class="card-text text-center p-3">
                            <h5 class="card-title color-white mb-1">
                                <?php echo e($project->title); ?>

                            </h5>

                            <span class="font-sm color-white d-block">
                                <i class="fal fa-map-marker-alt"></i>
                                <?php echo e($project->address); ?>

                            </span>

                            <span class="price d-block mt-1">
                                <?php echo e(symbolPrice($project->min_price)); ?>

                                <?php echo e(!empty($project->max_price) ? ' - ' . symbolPrice($project->max_price) : ''); ?>

                            </span>
                        </div>
                    

                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="p-3 text-center mb-30 w-100">
                <h3 class="mb-0"><?php echo e(__('No Project Found')); ?></h3>
            </div>
        <?php endif; ?>

    </div>
     <div class="pagination mb-30 justify-content-center">
           <?php echo e($projects->links()); ?>

      </div>
</div>






                  
              </div>
          </div>
      </section>
    <?php endif; ?>
    

  <?php if($secInfo->testimonial_section_status == 1): ?>
       <section class="testimonial-area testimonial-2 with-radius pt-100 pb-70">
            <!-- Bg image -->
            <img class="lazyload bg-img" src="<?php echo e(asset('assets/img/' . $testimonialSecImage)); ?>">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-4">
                        <div class="content mb-30" data-aos="fade-up">
                            <div class="content-title">
                                <span class="subtitle">
                                    <?php echo e($testimonialSecInfo->title); ?></span>
                                <h2 class="title">
                                    <?php echo e($testimonialSecInfo?->subtitle); ?> </h2>
                            </div>
                            <p class="text mb-30">
                                <?php echo e($testimonialSecInfo?->content); ?></p>
                            <!-- Slider pagination -->
                            <div class="swiper-pagination pagination-fraction" id="testimonial-slider-2-pagination">
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-8" data-aos="fade-up">
                        <div class="swiper" id="testimonial-slider-2">
                            <div class="swiper-wrapper">
                                <?php $__empty_1 = true; $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <div class="swiper-slide pb-30">
                                        <div class="slider-item">
                                            <div class="client-content">
                                                <div class="quote">
                                                    <p class="text mb-20"><?php echo e($testimonial->comment); ?></p>
                                                    <div class="ratings">
                                                        <div class="rate">
                                                            <div class="rating-icon"
                                                                style="width: <?php echo e($testimonial->rating * 20); ?>%"></div>
                                                        </div>
                                                        <span class="ratings-total">(<?php echo e($testimonial->rating); ?>) </span>
                                                    </div>
                                                </div>
                                                <div class="client-info d-flex align-items-center">
                                                    <div class="client-img position-static">
                                                        <div class="lazy-container rounded-pill ratio ratio-1-1">
                                                            <?php if(is_null($testimonial->image)): ?>
                                                                <img data-src="<?php echo e(asset('assets/img/profile.jpg')); ?>"
                                                                    class="lazyload">
                                                            <?php else: ?>
                                                                <img class="lazyload"
                                                                    data-src="<?php echo e(asset('assets/img/clients/' . $testimonial->image)); ?>">
                                                            <?php endif; ?>

                                                        </div>
                                                    </div>
                                                    <div class="content">
                                                        <h6 class="name"><?php echo e($testimonial->name); ?></h6>
                                                        <span class="designation"><?php echo e($testimonial->occupation); ?></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <div class="p-3 text-center mb-30 w-100">
                                        <h3 class="mb-0"> <?php echo e(__('No Testimonials Found')); ?></h3>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>

    


<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.layout-v' . $version, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\creabiz\paradox\resources\views/frontend/home/index-v2.blade.php ENDPATH**/ ?>