
<?php if ($__env->exists('backend.partials.rtl_style')) echo $__env->make('backend.partials.rtl_style', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->startSection('content'); ?>
    <div class="page-header">
        <h4 class="page-title">
            <?php if(request()->input('status') == 'all'): ?>
                <?php echo e(__('All Request')); ?>

            <?php elseif(request()->input('status') == 'pending'): ?>
                <?php echo e(__('Pending Request')); ?>

            <?php elseif(request()->input('status') == 'accepted'): ?>
                <?php echo e(__('Accepted Request')); ?>

            <?php endif; ?>
        </h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="<?php echo e(route('admin.dashboard')); ?>">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#"><?php echo e(__('Feature Properties')); ?></a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">
                    <?php if(request()->input('status') == 'all'): ?>
                        <?php echo e(__('All Request')); ?>

                    <?php elseif(request()->input('status') == 'pending'): ?>
                        <?php echo e(__('Pending Request')); ?>

                    <?php elseif(request()->input('status') == 'accepted'): ?>
                        <?php echo e(__('Accepted Request')); ?>

                    <?php endif; ?>
                </a>
            </li>
        </ul>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <form action="<?php echo e(route('admin.requested_for_featured')); ?>" method="GET">

                        <div class="row">

                            <div class="col-lg-3">
                                <div class="form-group">
                                    <label for="lan" class="form-label"><?php echo e(__('Language')); ?></label>
                                    <?php if(!empty($langs)): ?>
                                        <select name="language" id="lan" class="form-control">
                                            <option selected disabled><?php echo e(__('Select a Language')); ?></option>
                                            <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($lang->code); ?>"
                                                    <?php echo e($lang->code == request()->input('language') ? 'selected' : ''); ?>>
                                                    <?php echo e($lang->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="col-lg-3">
                                <div class="form-group">
                                    <label for="tran" class="form-label"><?php echo e(__('Transation Number')); ?></label>
                                    <input type="text" id="tran" class="form-control"
                                        value="<?php echo e(request()->input('transaction')); ?>" placeholder="Search Here..."
                                        name="transaction">
                                </div>
                            </div>
                            <div class="col-lg-3">
                                <div class="form-group">
                                    <label for="titl" class="form-label"><?php echo e(__('Property Title')); ?></label>
                                    <input type="text" id="titl" class="form-control"
                                        value="<?php echo e(request()->input('property')); ?>" placeholder="Search Here..."
                                        name="property">
                                </div>
                            </div>
                            <div class="col-lg-1">
                                <div class="form-group">
                                    <label for="payment" class="form-label"><?php echo e(__('Payment Status')); ?> </label>
                                    <select name="payment" id="payment" class="form-control">
                                        <option value="all"
                                            <?php echo e(request()->input('payment') == 'all' ? 'selected' : ''); ?>>
                                            All</option>
                                        <option value="pending"
                                            <?php echo e(request()->input('payment') == 'pending' ? 'selected' : ''); ?>> <?php echo e(__('Pending')); ?>

                                        </option>
                                        <option value="complete"
                                            <?php echo e(request()->input('payment') == 'complete' ? 'selected' : ''); ?>> <?php echo e(__('Complete')); ?>

                                        </option>
                                        <option value="rejected"
                                            <?php echo e(request()->input('payment') == 'rejected' ? 'selected' : ''); ?>> <?php echo e(__('Rejected')); ?>

                                        </option>
                                    </select>
                                </div>

                            </div>
                            <div class="col-lg-1">
                                <div class="form-group">
                                <label for="Status" class="form-label"><?php echo e(__('Featured Status')); ?> </label>
                                <select name="status" id="Status" class="form-control">
                                    <option value="all" <?php echo e(request()->input('status') == 'all' ? 'selected' : ''); ?>> <?php echo e(__('All')); ?>

                                    </option>
                                    <option value="pending"
                                        <?php echo e(request()->input('status') == 'pending' ? 'selected' : ''); ?>>
                                        Pending</option>
                                    <option value="featured"
                                        <?php echo e(request()->input('status') == 'featured' ? 'selected' : ''); ?>> <?php echo e(__('Featured')); ?></option>
                                    <option value="rejected"
                                        <?php echo e(request()->input('status') == 'rejected' ? 'selected' : ''); ?>> <?php echo e(__('Rejected')); ?></option>
                                </select>
                                </div>
                            </div>
                            <div class="col-lg-1 align-self-center">
                                <button type="submit" class="btn mt-2 btn-primary">
                                    Search</button>
                            </div>

                    </form>
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-lg-12">
                        <?php if(count($featuredRequests) == 0): ?>
                            <h3 class="text-center"><?php echo e(__('NO REQUEST FOUND YET')); ?></h3>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="table table-striped mt-3" id="basic-datatables">
                                    <thead>
                                        <tr>

                                            <th scope="col"><?php echo e(__('Transation No')); ?></th>
                                            <th scope="col"><?php echo e(__('Property Title')); ?></th>
                                            <th scope="col"><?php echo e(__('Vendor')); ?></th>
                                            <th scope="col"><?php echo e(__('Pay Via')); ?></th>
                                            <th scope="col"><?php echo e(__('Payment Status')); ?></th>
                                            <th scope="col"><?php echo e(__('Attachment/Receipt')); ?></th>
                                            <th scope="col"><?php echo e(__('Featured Status')); ?></th>
                                            <th scope="col"><?php echo e(__('Actions')); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $featuredRequests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $propertyTitle = $request->property?->getContent($language->id)?->title;
                                                $propertySlug = $request->property?->getContent($language->id)?->slug;
                                            ?>

                                            <tr>
                                                <td>#<?php echo e($request->transaction_id); ?></td>
                                                <td class="table-title">
                                                    <?php if(!empty($propertyTitle)): ?>
                                                        <a href="<?php echo e(route('frontend.property.details', ['slug' => $propertySlug])); ?>"
                                                            target="_blank">
                                                            <?php echo e(strlen($propertyTitle) > 100 ? mb_substr(@$propertyTitle, 0, 100, 'utf-8') . '...' : $propertyTitle); ?>

                                                        </a>
                                                    <?php endif; ?>

                                                </td>
                                                <td>
                                                    <?php if($request->vendor_id != 0): ?>
                                                        <a
                                                            href="<?php echo e(route('admin.vendor_management.vendor_details', ['id' => @$request->vendor->id, 'language' => $defaultLang->code])); ?>"><?php echo e(@$request->vendor->username); ?></a>
                                                    <?php else: ?>
                                                        <span class="badge badge-success"><?php echo e(__('Admin')); ?></span>
                                                    <?php endif; ?>
                                                </td>

                                                <td><span class="text-capitalize"> <?php echo e($request->gateway_type); ?>

                                                    </span>
                                                </td>

                                                <td> <?php echo e($request->price); ?>

                                                    <?php if($request->payment_status == 'complete'): ?>
                                                        <span class="badge badge-success"> <?php echo e('Complete'); ?>

                                                        </span>
                                                    <?php elseif($request->payment_status == 'pending'): ?>
                                                        <form id="statusForm<?php echo e($request->id); ?>" class="d-inline-block"
                                                            action="<?php echo e(route('admin.update_featured_payment_status')); ?>"
                                                            method="post">
                                                            <?php echo csrf_field(); ?>
                                                            <input type="hidden" name="requestId"
                                                                value="<?php echo e($request->id); ?>">

                                                            <select
                                                                class="form-control <?php echo e($request->payment_status == 'pending' ? 'bg-warning' : 'bg-danger'); ?> form-control-sm"
                                                                name="payment_status"
                                                                onchange="$('.request-loader').addClass('show');document.getElementById('statusForm<?php echo e($request->id); ?>').submit();">


                                                                <option
                                                                    <?php echo e($request->payment_status == 'pending' ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Pending')); ?>

                                                                </option>
                                                                <option value="complete">
                                                                    <?php echo e(__('Complete')); ?>

                                                                </option>
                                                                <option value="rejected"
                                                                    <?php echo e($request->payment_status == 'rejected' ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Reject')); ?>

                                                                </option>
                                                            </select>
                                                        </form>
                                                    <?php else: ?>
                                                        <span class="badge badge-danger"> <?php echo e(__('Rejected')); ?>

                                                        </span>
                                                    <?php endif; ?>
                                                </td>

                                                <td>
                                                    <?php if(!empty($request->attachment)): ?>
                                                        <a class="btn btn-sm btn-info" href="#" data-toggle="modal"
                                                            data-target="#attachmentModal<?php echo e($request->id); ?>">
                                                            <?php echo e(__('Show')); ?>

                                                        </a>
                                                        <?php if ($__env->exists('backend.featured-properties.show_attachment')) echo $__env->make('backend.featured-properties.show_attachment', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                    <?php else: ?>
                                                        -
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php if($request->payment_status == 'complete'): ?>
                                                        <?php if($request->status == 1 || (!empty($request->start_date) && !empty($request->end_date))): ?>
                                                            <?php if($request->isExpired): ?>
                                                                <h2 class="d-inline-block">
                                                                    <span
                                                                        class="badge badge-primary"><?php echo e(__('Expired')); ?></span>
                                                                </h2>
                                                            <?php else: ?>
                                                                <h2 class="d-inline-block">
                                                                    <span
                                                                        class="badge badge-success"><?php echo e(__('Featured')); ?></span>
                                                                </h2>
                                                            <?php endif; ?>
                                                        <?php elseif($request->status == 2): ?>
                                                            <span class="badge badge-danger"><?php echo e(__('Rejected')); ?></span>
                                                        <?php else: ?>
                                                            <form id="statusForm<?php echo e($request->id); ?>"
                                                                class="d-inline-block"
                                                                action="<?php echo e(route('admin.edit_featured_status')); ?>"
                                                                method="post">
                                                                <?php echo csrf_field(); ?>
                                                                <input type="hidden" name="requestId"
                                                                    value="<?php echo e($request->id); ?>">

                                                                <select
                                                                    class="form-control <?php if($request->status == 0): ?> bg-warning <?php elseif($request->status == 1): ?> bg-success <?php else: ?> bg-danger <?php endif; ?> form-control-sm"
                                                                    name="status"
                                                                    onchange="$('.request-loader').addClass('show');document.getElementById('statusForm<?php echo e($request->id); ?>').submit();">
                                                                    <option value="1"
                                                                        <?php echo e($request->status == 1 ? 'selected' : ''); ?>>
                                                                        <?php echo e(__('Approve')); ?>

                                                                    </option>
                                                                    <option value="0"
                                                                        <?php echo e($request->status == 0 ? 'selected' : ''); ?>>
                                                                        <?php echo e(__('Pending')); ?>

                                                                    </option>
                                                                    <option value="2"
                                                                        <?php echo e($request->status == 2 ? 'selected' : ''); ?>>
                                                                        <?php echo e(__('Rejected')); ?>

                                                                    </option>
                                                                </select>
                                                            </form>
                                                        <?php endif; ?>
                                                    <?php elseif($request->payment_status == 'pending'): ?>
                                                        <span class="badge badge-warning"> <?php echo e('Pending'); ?>

                                                        </span>
                                                    <?php elseif($request->payment_status == 'rejected'): ?>
                                                        <span class="badge badge-danger"> <?php echo e('Rejecteds'); ?>

                                                        </span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php
                                                        $endDate = \Carbon\Carbon::parse($request->end_date);
                                                    ?>
                                                   
                                                    <form class="deleteForm d-inline-block"
                                                        action="<?php echo e(route('admin.delete_featured_request')); ?>"
                                                        method="post">
                                                        <?php echo csrf_field(); ?>
                                                        <input type="hidden" name="id"
                                                            value="<?php echo e($request->id); ?>">

                                                        <button type="submit"
                                                            class="btn btn-danger  mt-1 btn-sm deleteBtn">
                                                            <span class="btn-label">
                                                                <i class="fas fa-trash"></i>
                                                            </span>
                                                        </button>
                                                    </form>
                                                     
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\creabiz\paradox\resources\views/backend/featured-properties/featured-request.blade.php ENDPATH**/ ?>