 <div <?php echo e($attributes); ?>>
     <div class="product-default radius-md mb-30" <?php echo e($animation ? 'data-aos="fade-up" data-aos-delay="100"' : ''); ?>>
         <figure class="product-img">
             <a href="<?php echo e(route('frontend.property.details', ['slug' => $property->slug ?? $property->propertyContent->slug])); ?>"
                 class="lazy-container ratio ratio-1-1">
                 <img class="lazyload" src="assets/images/placeholder.png"
                     data-src="<?php echo e(asset('assets/img/property/featureds/' . $property->featured_image)); ?>">
             </a>
         </figure>
         <div class="product-details">
             <div class="d-flex align-items-center justify-content-between mb-10">
                 <div class="author  ">

                     <?php if($property->agent): ?>
                         <a class="color-medium"
                             href="<?php echo e(route('frontend.agent.details', ['username' => $property->agent->username])); ?>"
                             target="_self">

                             <img class="blur-up ls-is-cached lazyloaded"
                                 data-src="<?php echo e($property->agent->image ? asset('assets/img/agents/' . $property->agent->image) : asset('assets/img/blank-user.jpg')); ?>"
                                 src="<?php echo e($property->agent->image ? asset('assets/img/agents/' . $property->agent->image) : asset('assets/img/blank-user.jpg')); ?>">
                             <span><?php echo e(__('By')); ?> <?php echo e($property->agent->username); ?></span>
                         <?php elseif($property->vendor): ?>
                             <a class="color-medium"
                                 href="<?php echo e(route('frontend.vendor.details', ['username' => $property->vendor->username])); ?>"
                                 target="_self">

                                 <img class="blur-up ls-is-cached lazyloaded"
                                     data-src="<?php echo e($property->vendor->photo ? asset('assets/admin/img/vendor-photo/' . $property->vendor->photo) : asset('assets/img/blank-user.jpg')); ?>"
                                     src="<?php echo e($property->vendor->photo ? asset('assets/admin/img/vendor-photo/' . $property->vendor->photo) : asset('assets/img/blank-user.jpg')); ?>">
                                 <span><?php echo e(__('By')); ?> <?php echo e($property->vendor->username); ?></span>
                             <?php elseif($property->vendor_id == 0): ?>
                                 <?php
                                     $admin = App\Models\Admin::where('role_id', null)->with('adminInfo')->first();
                                 ?>
                                 <a class="color-medium"
                                     href="<?php echo e(route('frontend.vendor.details', ['username' => $admin->username, 'admin' => 'true'])); ?>"
                                     target="_self">

                                     <img class="blur-up ls-is-cached lazyloaded"
                                         data-src="<?php echo e($admin->image ? asset('assets/img/admins/' . $admin->image) : asset('assets/img/blank-user.jpg')); ?>"
                                         src="<?php echo e($admin->image ? asset('assets/img/admins/' . $admin->image) : asset('assets/img/blank-user.jpg')); ?>">
                                     <span><?php echo e(__('By')); ?> <?php echo e($admin->username); ?></span>
                     <?php endif; ?>

                     </a>
                 </div>

                 <span class="product-category text-sm"><?php echo e(__(ucfirst($property->type))); ?></span>

             </div>
             <h3 class="product-title">
                 <a
                     href="<?php echo e(route('frontend.property.details', $property->slug ?? $property->propertyContent->slug)); ?>"><?php echo e($property->title ?? $property->propertyContent->title); ?></a>
             </h3>

             <span class="product-location icon-start"> <i class="fal fa-map-marker-alt"></i>
                 <?php echo e($property->city->getContent($property->language_id)?->name); ?>

                 <?php echo e($property->isStateActive ? ', ' . $property->state?->getContent($property->language_id)?->name : ''); ?>

                 <?php echo e($property->isCountryActive ? ', ' . $property->country?->getContent($property->language_id)?->name : ''); ?>

             </span>
             <div class="product-price">
                 <span class="new-price"><?php echo e(__('Price:')); ?>

                     <?php echo e($property->price ? symbolPrice($property->price) : __('Negotiable')); ?></span>
             </div>
             <ul class="product-info p-0 list-unstyled d-flex align-items-center">
                 <li class="icon-start" data-tooltip="tooltip" data-bs-placement="top" title="<?php echo e(__('Area')); ?>">
                     <i class="fal fa-vector-square"></i>
                     <span><?php echo e($property->area); ?> <?php echo e(__('Sqft')); ?></span>
                 </li>
                 <?php if($property->type == 'residential'): ?>
                     <li class="icon-start" data-tooltip="tooltip" data-bs-placement="top" title="<?php echo e(__('Beds')); ?>">
                         <i class="fal fa-bed"></i>
                         <span><?php echo e($property->beds); ?> <?php echo e(__('Beds')); ?></span>
                     </li>
                     <li class="icon-start" data-tooltip="tooltip" data-bs-placement="top" title="<?php echo e(__('Baths')); ?>">
                         <i class="fal fa-bath"></i>
                         <span><?php echo e($property->bath); ?> <?php echo e(__('Baths')); ?></span>
                     </li>
                 <?php endif; ?>
             </ul>
         </div>
         <span class="label"><?php echo e(__(ucfirst($property->purpose))); ?></span>
         <?php if(Auth::guard('web')->check()): ?>
             <?php
                 $user_id = Auth::guard('web')->user()->id;
                 $checkWishList = checkWishList($property->id, $user_id);
             ?>
         <?php else: ?>
             <?php
                 $checkWishList = false;
             ?>
         <?php endif; ?>
         <a href="<?php echo e($checkWishList == false ? route('addto.wishlist', $property->id) : route('remove.wishlist', $property->id)); ?>"
             class="btn-wishlist <?php echo e($checkWishList == false ? '' : 'wishlist-active'); ?>" data-tooltip="tooltip"
             data-bs-placement="top" title="<?php echo e($checkWishList == false ? __('Add to Wishlist') : __('Saved')); ?>">
             <i class="fal fa-heart"></i>
         </a>
     </div><!-- product-default -->
 </div>
<?php /**PATH C:\xampp\htdocs\creabiz\paradox\resources\views/components/property.blade.php ENDPATH**/ ?>