


<?php if ($__env->exists('backend.partials.rtl_style')) echo $__env->make('backend.partials.rtl_style', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->startSection('content'); ?>
    <div class="page-header">
        <h4 class="page-title"><?php echo e(__('Project')); ?></h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="<?php echo e(route('admin.dashboard')); ?>">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#"><?php echo e(__('Project Management')); ?></a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#"><?php echo e(__('Projects')); ?></a>
            </li>
        </ul>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-3">
                            <div class="card-title pt-lg-3 d-inline-block justify-item-center"><?php echo e(__('Projects')); ?></div>
                        </div>

                        <div class="col-lg-4">
                            <form action="<?php echo e(route('admin.project_management.projects')); ?>" method="get"
                                id="carSearchForm">
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <select name="vendor_id" id="" class="select2"
                                                onchange="document.getElementById('carSearchForm').submit()">
                                                <option value="" selected><?php echo e(__('All')); ?></option>
                                                <option value="admin" <?php if(request()->input('vendor_id') == 'admin'): echo 'selected'; endif; ?>><?php echo e(__('Admin')); ?>

                                                </option>
                                                <?php $__currentLoopData = $vendors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vendor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option <?php if($vendor->id == request()->input('vendor_id')): echo 'selected'; endif; ?> value="<?php echo e($vendor->id); ?>">
                                                        <?php echo e($vendor->username); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <input type="text" name="title" value="<?php echo e(request()->input('title')); ?>"
                                                class="form-control" placeholder="Title">
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-lg-3">
                            <div class="form-group">
                                <?php if ($__env->exists('backend.partials.languages')) echo $__env->make('backend.partials.languages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        </div>

                        <div class="col-lg-2 mt-2 mt-lg-0">
                            <a href="<?php echo e(route('admin.project_management.create_project')); ?>"
                                class="btn btn-primary btn-sm mt-lg-3 float-lg-right"><i class="fas fa-plus"></i>
                                <?php echo e(__('Add Project')); ?></a>

                            <button class="btn btn-danger btn-sm float-right mt-lg-3 mr-2 d-none bulk-delete"
                                data-href="<?php echo e(route('admin.project_management.bulk_delete_project')); ?>"><i
                                    class="flaticon-interface-5"></i>
                                <?php echo e(__('Delete')); ?></button>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-12">
                            <?php if(count($projects) == 0): ?>
                                <h3 class="text-center"><?php echo e(__('NO PROJECT FOUND!')); ?></h3>
                            <?php else: ?>
                                <div class="table-responsive">
                                    <table class="table table-striped mt-3">
                                        <thead>
                                            <tr>
                                                <th scope="col">
                                                    <input type="checkbox" class="bulk-check" data-val="all">
                                                </th>
                                                <th scope="col"><?php echo e(__('Title')); ?></th>
                                                <th scope="col"><?php echo e(__('Post by')); ?></th>
                                                <th scope="col"><?php echo e(__('Type')); ?></th>
                                                <th scope="col"><?php echo e(__('Approval Status')); ?></th>
                                                <th scope="col"><?php echo e(__('Featured')); ?></th>
                                                <th scope="col"><?php echo e(__('Status')); ?></th>
                                                <th scope="col"><?php echo e(__('Actions')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td>
                                                        <input type="checkbox" class="bulk-check"
                                                            data-val="<?php echo e($project->id); ?>">
                                                    </td>
                                                    <td class="table-title">
                                                        <?php
                                                            $project_content = $project->getContent($language->id);
                                                            if (is_null($project_content)) {
                                                                $project_content = $project->projectContents()->first();
                                                            }
                                                        ?>
                                                        <?php if(!empty($project_content)): ?>
                                                            <a href="<?php echo e(route('frontend.projects.details', ['slug' => $project_content->slug])); ?>"
                                                                target="_blank">
                                                                <?php echo e(strlen(@$project_content->title) > 100 ? mb_substr(@$project_content->title, 0, 100, 'utf-8') . '...' : @$project_content->title); ?>

                                                            </a>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <?php if($project->vendor_id != 0): ?>
                                                            <a
                                                                href="<?php echo e(route('admin.vendor_management.vendor_details', ['id' => @$project->vendor->id, 'language' => $defaultLang->code])); ?>"><?php echo e(@$project->vendor->username); ?></a>
                                                        <?php else: ?>
                                                            <span class="badge badge-success"><?php echo e(__('Admin')); ?></span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <a class="btn btn-secondary  mt-1 btn-sm mr-1"
                                                            href="<?php echo e(route('admin.project_management.project_types', $project->id)); ?>">
                                                            <span class="btn-label">
                                                                <?php echo e(__('Manage')); ?>

                                                            </span>
                                                        </a>
                                                    </td>

                                                    <td>
                                                        <form class="d-inline-block"
                                                            action="<?php echo e(route('admin.project_management.approve_status')); ?>"
                                                            method="POST">
                                                            <?php echo csrf_field(); ?>
                                                            <input type="hidden" name="project"
                                                                value="<?php echo e($project->id); ?>">
                                                            <select
                                                                onchange="$('.request-loader').addClass('show'); this.form.submit();"
                                                                class="form-control  <?php if($project->approve_status == 1): ?> bg-success <?php elseif($project->approve_status == 0): ?>
                                                                bg-warning <?php else: ?> bg-danger <?php endif; ?> form-control-sm"
                                                                name="approve_status">
                                                                <option value="2"
                                                                    <?php echo e($project->approve_status == 2 ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Rejected')); ?>

                                                                </option>
                                                                <option value="1"
                                                                    <?php echo e($project->approve_status == 1 ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Approve')); ?>

                                                                </option>
                                                                <option value="0"
                                                                    <?php echo e($project->approve_status == 0 ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Pending')); ?>

                                                                </option>
                                                            </select>
                                                        </form>
                                                    </td>

                                                    <td>
                                                        <form id="featureForm<?php echo e($project->id); ?>" class="d-inline-block"
                                                            action="<?php echo e(route('admin.project_management.update_featured')); ?>"
                                                            method="post">
                                                            <?php echo csrf_field(); ?>
                                                            <input type="hidden" name="projectId"
                                                                value="<?php echo e($project->id); ?>">

                                                            <select
                                                                class="form-control <?php echo e($project->featured == 1 ? 'bg-success' : 'bg-danger'); ?> form-control-sm"
                                                                name="featured"
                                                                onchange="document.getElementById('featureForm<?php echo e($project->id); ?>').submit();">
                                                                <option value="1"
                                                                    <?php echo e($project->featured == 1 ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Yes')); ?>

                                                                </option>
                                                                <option value="0"
                                                                    <?php echo e($project->featured == 0 ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('No')); ?>

                                                                </option>
                                                            </select>
                                                        </form>

                                                    </td>

                                                    <td>
                                                        <form id="statusForm<?php echo e($project->id); ?>" class="d-inline-block"
                                                            action="<?php echo e(route('admin.project_management.update_status')); ?>"
                                                            method="post">
                                                            <?php echo csrf_field(); ?>
                                                            <input type="hidden" name="projectId"
                                                                value="<?php echo e($project->id); ?>">

                                                            <select
                                                                class="form-control <?php echo e($project->status == 1 ? 'bg-success' : 'bg-danger'); ?> form-control-sm"
                                                                name="status"
                                                                onchange="document.getElementById('statusForm<?php echo e($project->id); ?>').submit();">
                                                                <option value="1"
                                                                    <?php echo e($project->status == 1 ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Complete')); ?>

                                                                </option>
                                                                <option value="0"
                                                                    <?php echo e($project->status == 0 ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Under Construction')); ?>

                                                                </option>
                                                            </select>
                                                        </form>
                                                    </td>

                                                    <td>
                                                        <div class="dropdown">
                                                            <button class="btn btn-secondary dropdown-toggle btn-sm"
                                                                type="button" id="dropdownMenuButton"
                                                                data-toggle="dropdown" aria-haspopup="true"
                                                                aria-expanded="false">
                                                                <?php echo e(__('Select')); ?>

                                                            </button>

                                                            <div class="dropdown-menu"
                                                                aria-labelledby="dropdownMenuButton">

                                                                <a class="dropdown-item"
                                                                    href="<?php echo e(route('admin.project_management.edit', $project->id)); ?>">
                                                                    <span class="btn-label">
                                                                        <i class="fas fa-edit"></i> <?php echo e(__('Edit')); ?>

                                                                    </span>
                                                                </a>

                                                                <form class="deleteForm d-inline-block dropdown-item"
                                                                    action="<?php echo e(route('admin.project_management.delete_project')); ?>"
                                                                    method="post">
                                                                    <?php echo csrf_field(); ?>
                                                                    <input type="hidden" name="project_id"
                                                                        value="<?php echo e($project->id); ?>">

                                                                    <button type="submit" class="p-0 deleteBtn">
                                                                        <span class="btn-label">
                                                                            <i class="fas fa-trash-alt"></i>
                                                                            <?php echo e(__('Delete')); ?>

                                                                        </span>
                                                                    </button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="card-footer">
                    <?php echo e($projects->appends([
                            'vendor_id' => request()->input('vendor_id'),
                            'title' => request()->input('title'),
                        ])->links()); ?>

                </div>

            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\creabiz\paradox\resources\views/backend/project/index.blade.php ENDPATH**/ ?>