<!DOCTYPE html>
<html lang="xxx" dir="<?php echo e($currentLanguageInfo->direction == 1 ? 'rtl' : ''); ?>">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="author" content="KreativDev">

    <meta name="keywords" content="<?php echo $__env->yieldContent('metaKeywords'); ?>">
    <meta name="description" content="<?php echo $__env->yieldContent('metaDescription'); ?>">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />
    <meta property="og:type" content="website">
    <?php echo $__env->yieldContent('og:tag'); ?>
    
    <title><?php echo $__env->yieldContent('pageHeading'); ?> <?php echo e('| ' . $websiteInfo->website_title); ?></title>
    
    <link rel="shortcut icon" type="image/png" href="<?php echo e(asset('assets/img/' . $websiteInfo->favicon)); ?>">
    <link rel="apple-touch-icon" href="<?php echo e(asset('assets/img/' . $websiteInfo->favicon)); ?>">

    <?php
        $primaryColor = 'BDA588';
        $secoundaryColor = '352008';
        // check, whether color has '#' or not, will return 0 or 1
        function checkColorCode($color)
        {
            return preg_match('/^#[a-f0-9]{6}/i', $color);
        }

        // if, primary color value does not contain '#', then add '#' before color value
        if (isset($primaryColor) && checkColorCode($primaryColor) == 0) {
            $primaryColor = '#' . $primaryColor;
            $secoundaryColor = '#' . $secoundaryColor;
        }

        // change decimal point into hex value for opacity
        function rgb($color = null)
        {
            if (!$color) {
                echo '';
            }
            $hex = htmlspecialchars($color);
            [$r, $g, $b] = sscanf($hex, '#%02x%02x%02x');
            echo "$r, $g, $b";
        }
    ?>
    <?php if ($__env->exists('frontend.partials.styles.styles-v2')) echo $__env->make('frontend.partials.styles.styles-v2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <style>
        :root {
            --color-primary: <?php echo e($primaryColor); ?>;
            --color-primary-rgb: <?php echo e(rgb(htmlspecialchars($primaryColor))); ?>;
            --color-secondary: <?php echo e($secoundaryColor); ?>;
            --color-secondary-rgb: <?php echo e(rgb(htmlspecialchars($secoundaryColor))); ?>;
        }
    </style>


</head>

<body dir="<?php echo e($currentLanguageInfo->direction == 1 ? 'rtl' : ''); ?>">

    <?php if ($__env->exists('frontend.partials.header.header-v2')) echo $__env->make('frontend.partials.header.header-v2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->yieldContent('content'); ?>

    <?php if ($__env->exists('frontend.partials.popups')) echo $__env->make('frontend.partials.popups', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('frontend.partials.footer.footer-v2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    
    <?php if(!is_null($cookieAlertInfo) && $cookieAlertInfo->cookie_alert_status == 1): ?>
        <?php echo $__env->make('cookie-consent::index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>
    
    <div id="WAButton"></div>

    <?php if ($__env->exists('frontend.partials.scripts.scripts-v2')) echo $__env->make('frontend.partials.scripts.scripts-v2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php if ($__env->exists('frontend.partials.toastr')) echo $__env->make('frontend.partials.toastr', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>

</html>
<?php /**PATH C:\xampp\htdocs\CreaBiz\paradox\resources\views/frontend/layouts/layout-v2.blade.php ENDPATH**/ ?>