

<?php $__env->startSection('content'); ?>
    <div class="page-header">
        <h4 class="page-title"><?php echo e(__('Add Project')); ?></h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="<?php echo e(route('admin.dashboard')); ?>">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#"><?php echo e(__('Project Management')); ?></a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#"><?php echo e(__('Add Project')); ?></a>
            </li>
        </ul>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="card-title d-inline-block"><?php echo e(__('Add Project')); ?></div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-10 offset-lg-1">
                            <div class="alert alert-danger pb-1 dis-none" id="carErrors">
                                <button type="button" class="close" data-dismiss="alert">×</button>
                                <ul></ul>
                            </div>
                            <div class="row">
                                <div class="col-lg-6">
                                    <label for="" class="mb-2"><strong><?php echo e(__('Gallery Images')); ?>

                                            **</strong></label>
                                    <form action="<?php echo e(route('admin.project.gallery_image_store')); ?>" id="my-dropzone"
                                        enctype="multipart/form-data" class="dropzone create">
                                        <?php echo csrf_field(); ?>
                                        <div class="fallback">
                                            <input name="file" type="file" multiple />
                                        </div>
                                    </form>
                                    <p class="em text-danger mb-0" id="errgallery_images"></p>
                                </div>

                                <div class="col-lg-6">
                                    <label for="" class="mb-2"><strong><?php echo e(__('Floor Plan Images')); ?>

                                            **</strong></label>
                                    <form action="<?php echo e(route('admin.property.imagesstore')); ?>" id="my-dropzone2"
                                        enctype="multipart/form-data" class="dropzone create">
                                        <?php echo csrf_field(); ?>
                                        <div class="fallback">
                                            <input name="file" type="file" multiple />
                                        </div>
                                    </form>
                                    <p class="em text-danger mb-0" id="errfloor_plan_images"></p>
                                </div>
                            </div>
                            <form id="carForm" action="<?php echo e(route('admin.project_management.store_project')); ?>"
                                method="POST" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="type" value="<?php echo e(request()->type); ?>">
                                <div id="sliders"></div>
                                <div id="floorPlan"></div>
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for=""><?php echo e(__('Feature Image') . '*'); ?></label>
                                            <br>
                                            <div class="thumb-preview">
                                                <img src="<?php echo e(asset('assets/img/noimage.jpg')); ?>" alt="..."
                                                    class="uploaded-img">
                                            </div>

                                            <div class="mt-3">
                                                <div role="button" class="btn btn-primary btn-sm upload-btn">
                                                    <?php echo e(__('Choose Image')); ?>

                                                    <input type="file" class="img-input" name="featured_image">
                                                </div>
                                            </div>
                                        </div>
                                    </div>


                                </div>

                                <div class="row">
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label><?php echo e(__('Min Price') . ' (' . $settings->base_currency_text . ')'); ?>

                                                *</label>
                                            <input type="number" class="form-control" name="min_price"
                                                placeholder="Enter Minimum Price">
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label><?php echo e(__('Max Price') . ' (' . $settings->base_currency_text . ')'); ?>

                                            </label>
                                            <input type="number" class="form-control" name="max_price"
                                                placeholder="Enter Maximum Price">
                                        </div>
                                    </div>

                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label><?php echo e(__('Featured')); ?> *</label>
                                            <select name="featured" id="" class="form-control">
                                                <option value="0"><?php echo e(__('No')); ?></option>
                                                <option value="1"><?php echo e(__('Yes')); ?></option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label><?php echo e(__('Status')); ?> *</label>
                                            <select name="status" id="" class="form-control">
                                                <option value="1"><?php echo e(__('Complete')); ?></option>
                                                <option value="0"><?php echo e(__('Under Construction')); ?></option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label><?php echo e(__('Latitude')); ?> </label>
                                            <input type="text" class="form-control" name="latitude"
                                                placeholder="Enter Latitude">
                                        </div>
                                    </div>

                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label><?php echo e(__('Longitude')); ?> </label>
                                            <input type="text" class="form-control" name="longitude"
                                                placeholder="Enter Longitude">
                                        </div>
                                    </div>

                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label for=""><?php echo e(__('Vendor')); ?></label>
                                            <select name="vendor_id" class="form-control vendor js-example-basic-single3">
                                                <option value="0" selected><?php echo e(__('Please Select')); ?>

                                                </option>
                                                <?php $__currentLoopData = $vendors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vendor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($vendor->id); ?>"><?php echo e($vendor->username); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <p class="text-warning">
                                                <?php echo e(__('if you do not select any agent, then this project will be listed under you')); ?>

                                            </p>
                                        </div>
                                    </div>

                                    <div class="col-lg-3">
                                        <div class="form-group agent d-none ">
                                            <label for=""><?php echo e(__('Agent')); ?></label>
                                            <select name="agent_id"
                                                class="form-control agent_id js-example-basic-single3">
                                                <option value="0"><?php echo e(__('Please Select')); ?>

                                                </option>

                                            </select>
                                            <p class="text-warning">
                                                <?php echo e(__('if you do not select any agent, then this project will be listed under Vendor')); ?>

                                            </p>
                                        </div>
                                    </div>

                                </div>

                                <div id="accordion" class="mt-3">
                                    <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="version">
                                            <div class="version-header" id="heading<?php echo e($language->id); ?>">
                                                <h5 class="mb-0">
                                                    <button type="button" class="btn btn-link" data-toggle="collapse"
                                                        data-target="#collapse<?php echo e($language->id); ?>"
                                                        aria-expanded="<?php echo e($language->is_default == 1 ? 'true' : 'false'); ?>"
                                                        aria-controls="collapse<?php echo e($language->id); ?>">
                                                        <?php echo e($language->name . __(' Language')); ?>

                                                        <?php echo e($language->is_default == 1 ? '(Default)' : ''); ?>

                                                    </button>
                                                </h5>
                                            </div>

                                            <div id="collapse<?php echo e($language->id); ?>"
                                                class="collapse <?php echo e($language->is_default == 1 ? 'show' : ''); ?>"
                                                aria-labelledby="heading<?php echo e($language->id); ?>" data-parent="#accordion">
                                                <div class="version-body">
                                                    <div class="row">
                                                        <div class="col-lg-8">
                                                            <div
                                                                class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                <label><?php echo e(__('Title')); ?> *</label>
                                                                <input type="text" class="form-control"
                                                                    name="<?php echo e($language->code); ?>_title"
                                                                    placeholder="Enter Title">
                                                            </div>
                                                        </div>


                                                        <div class="col-lg-4">
                                                            <div
                                                                class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                <label><?php echo e(__('Address') . '*'); ?></label>
                                                                <input type="text"
                                                                    name="<?php echo e($language->code); ?>_address"
                                                                    class="form-control" placeholder="Enter Address">
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="row">
                                                        <div class="col-lg-12">
                                                            <div
                                                                class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                <label><?php echo e(__('Description')); ?> *</label>
                                                                <textarea id="<?php echo e($language->code); ?>_description" class="form-control summernote"
                                                                    name="<?php echo e($language->code); ?>_description" data-height="300"></textarea>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="row">
                                                        <div class="col-lg-12">
                                                            <div
                                                                class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                <label><?php echo e(__('Meta Keywords')); ?> *</label>
                                                                <input class="form-control"
                                                                    name="<?php echo e($language->code); ?>_meta_keyword"
                                                                    placeholder="Enter Meta Keywords"
                                                                    data-role="tagsinput">
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="row">
                                                        <div class="col-lg-12">
                                                            <div
                                                                class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                <label><?php echo e(__('Meta Description')); ?> *</label>
                                                                <textarea class="form-control" name="<?php echo e($language->code); ?>_meta_description" rows="5"
                                                                    placeholder="Enter Meta Description"></textarea>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="row">
                                                        <div class="col">
                                                            <?php $currLang = $language; ?>

                                                            <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php if($language->id == $currLang->id) continue; ?>

                                                                <div class="form-check py-0">
                                                                    <label class="form-check-label">
                                                                        <input class="form-check-input" type="checkbox"
                                                                            onchange="cloneInput('collapse<?php echo e($currLang->id); ?>', 'collapse<?php echo e($language->id); ?>', event)">
                                                                        <span
                                                                            class="form-check-sign"><?php echo e(__('Clone for')); ?>

                                                                            <strong
                                                                                class="text-capitalize text-secondary"><?php echo e($language->name); ?></strong>
                                                                            <?php echo e(__('language')); ?></span>
                                                                    </label>
                                                                </div>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>

                                <div class="row">
                                    <div class="col-lg-12" id="variation_pricing">
                                        <h4 for=""><?php echo e(__('Additional Features (Optional)')); ?></h4>
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th><?php echo e(__('Label')); ?></th>
                                                    <th><?php echo e(__('Value')); ?></th>
                                                    <th><a href="" class="btn btn-sm btn-success addRow"><i
                                                                class="fas fa-plus-circle"></i></a></th>
                                                </tr>
                                            <tbody id="tbody">
                                                <tr>
                                                    <td>
                                                        <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <div
                                                                class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                <input type="text"
                                                                    name="<?php echo e($language->code); ?>_label[]"
                                                                    class="form-control"
                                                                    placeholder="Label (<?php echo e($language->name); ?>)">
                                                            </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </td>
                                                    <td>
                                                        <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <div
                                                                class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                <input type="text"
                                                                    name="<?php echo e($language->code); ?>_value[]"
                                                                    class="form-control"
                                                                    placeholder="Value (<?php echo e($language->name); ?>)">
                                                            </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </td>
                                                    <td>
                                                        <a href="javascript:void(0)"
                                                            class="btn btn-danger  btn-sm deleteRow">
                                                            <i class="fas fa-minus"></i></a>
                                                    </td>
                                                </tr>
                                            </tbody>
                                            </thead>
                                        </table>
                                    </div>
                                </div>

                                <div id="galleries"></div>
                                <div id="floorPlan"></div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="card-footer">
                    <div class="row">
                        <div class="col-12 text-center">
                            <button type="submit" id="PropertySubmit" class="btn btn-success">
                                <?php echo e(__('Save')); ?>

                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php
    $languages = App\Models\Language::get();
    $labels = '';
    $values = '';
    foreach ($languages as $language) {
        $label_name = $language->code . '_label[]';
        $value_name = $language->code . '_value[]';
        if ($language->direction == 1) {
            $direction = 'form-group rtl text-right';
        } else {
            $direction = 'form-group';
        }

        $labels .=
            "<div class='$direction'><input type='text' name='" .
            $label_name .
            "' class='form-control' placeholder='Label ($language->name)'></div>";
        $values .= "<div class='$direction'><input type='text' name='$value_name' class='form-control' placeholder='Value ($language->name)'></div>";
    }
?>

<?php $__env->startSection('script'); ?>
    <script>
        'use strict';
        var labels = "<?php echo $labels; ?>";
        var values = "<?php echo $values; ?>";
        var galleryStoreUrl = "<?php echo e(route('admin.project.gallery_image_store', ['vendor_id' => 0])); ?>";
        var galleryRemoveUrl = "<?php echo e(route('admin.project.gallery_imagermv')); ?>";
        var floorPlanStoreUrl = "<?php echo e(route('admin.project.floor_plan_image_store')); ?>";
        var floorPlanRemoveUrl = "<?php echo e(route('admin.project.floor_plan_imagermv')); ?>";
        let agentUrl = "<?php echo e(route('admin.property_management.get_agent')); ?>";
        let galleryImages = 999999;
    </script>

    <script type="text/javascript" src="<?php echo e(asset('assets/js/admin-partial.js')); ?>"></script>

    <script type="text/javascript" src="<?php echo e(asset('assets/js/admin-project-dropzone.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/property.js')); ?>"></script>

    <script>
        $(document).ready(function() {
            $('.state').hide();
            $('.city').hide();
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\creabiz\paradox\resources\views/backend/project/create.blade.php ENDPATH**/ ?>